/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner;

import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.reasoning.sseReasoner.Resolver;
import net.ssehub.easy.reasoning.sseReasoner.model.ReasoningUtils;
import net.ssehub.easy.varModel.confModel.CompoundVariable;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ResolvedVariable;
import net.ssehub.easy.varModel.cstEvaluation.IValueChangeListener;
import net.ssehub.easy.varModel.cstEvaluation.LocalDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueVisitorAdapter;

class RescheduleValueChangeVisitor
extends ValueVisitorAdapter
implements IValueChangeListener {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(RescheduleValueChangeVisitor.class, "net.ssehub.easy.reasoning.sseReasoner");
    private Resolver resolver;
    private boolean clear;
    private Value oldValue;
    private IDecisionVariable variable;
    private IDecisionVariable varParent;

    public RescheduleValueChangeVisitor(Resolver resolver) {
        this.resolver = resolver;
    }

    public void visitConstraintValue(ConstraintValue value) {
        List<Constraint> constraints = this.resolver.cleanupConstraints(this.varParent, this.clear, null);
        Value newValue = this.variable.getValue();
        ConstraintSyntaxTree cst = ReasoningUtils.getConstraintValueExpression(newValue);
        if (cst != null) {
            IModelElement parent = constraints == null || constraints.isEmpty() ? this.variable.getDeclaration().getParent() : constraints.get(0).getParent();
            ConstraintSyntaxTree selfEx = null;
            IDecisionVariable selfVar = this.variable;
            while (!(selfVar instanceof CompoundVariable) && !(selfVar instanceof IConfiguration)) {
                selfVar = selfVar.getParent();
            }
            if (selfVar instanceof CompoundVariable) {
                selfEx = ReasoningUtils.createParentExpression((IDecisionVariable)((CompoundVariable)selfVar));
            }
            Constraint c = this.resolver.createConstraintVariableConstraint(cst, selfEx, null, parent, this.varParent);
            ReasoningUtils.setValue(this.variable, c);
            this.resolver.moveOtherConstraintsToConstraintBase(this.variable);
        }
    }

    public void visitCompoundValue(CompoundValue newValue) {
        for (String name : newValue.getSlotNames()) {
            Value nValue = newValue.getNestedValue(name);
            if (nValue == null) continue;
            IDecisionVariable nVar = this.variable.getNestedElement(name);
            this.rescheduleValueChange(this.variable, nVar, nValue, true);
        }
    }

    public void visitContainerValue(ContainerValue newValue) {
        if (this.oldValue instanceof ContainerValue) {
            ContainerValue oldCValue = (ContainerValue)this.oldValue;
            int c = 0;
            while (c < newValue.getElementSize()) {
                this.rescheduleValueChange(this.variable, this.variable.getNestedElement(c), oldCValue != null && c < oldCValue.getElementSize() ? oldCValue.getElement(c) : null, c == 0);
                ++c;
            }
        }
    }

    void rescheduleValueChange(IDecisionVariable varParent, IDecisionVariable variable, Value oldValue, boolean clear) {
        IDecisionVariable sVarParent = this.varParent;
        IDecisionVariable sVariable = this.variable;
        Value sOldValue = this.oldValue;
        boolean sClear = this.clear;
        this.varParent = varParent;
        this.variable = variable;
        this.oldValue = oldValue;
        this.clear = clear;
        variable.getValue().accept((IValueVisitor)this);
        this.varParent = sVarParent;
        this.variable = sVariable;
        this.oldValue = sOldValue;
        this.clear = sClear;
    }

    public void notifyChanged(IDecisionVariable variable, Value oldValue, IAssignmentState oldState, IValueChangeListener.ChangeKind kind) {
        AbstractVariable decl = variable.getDeclaration();
        if (!variable.isLocal()) {
            this.resolver.notifyRescheduling(true);
            this.resolver.addAssignedVariableToScope(variable);
            Value newValue = variable.getValue();
            if (IValueChangeListener.ChangeKind.VARIABLE_ONLY == kind) {
                this.rescheduleConstraintsForChilds(variable, false);
            } else {
                if (!Value.equals((Value)newValue, (Value)oldValue)) {
                    this.rescheduleValueChange(variable, variable, oldValue, true);
                    if (this.isValueTypeChange(variable, newValue, oldValue)) {
                        this.resolver.translateValueTypeChange(variable, newValue, oldValue);
                    }
                }
                this.rescheduleConstraintsForChilds(variable, true);
                this.rescheduleConstraintsForParent(variable);
            }
            this.resolver.notifyRescheduling(false);
        } else if (this.resolver.contextContainsMapping(decl)) {
            IDecisionVariable var = ((LocalDecisionVariable)variable).getVariable();
            this.resolver.contextRegisterMapping(decl, (ConstraintSyntaxTree)(var == null ? null : new ResolvedVariable(var)));
        }
    }

    public void notifyUnresolved(IDecisionVariable variable) {
    }

    private boolean isValueTypeChange(IDecisionVariable variable, Value newValue, Value oldValue) {
        boolean result = false;
        if (TypeQueries.isCompound((IDatatype)variable.getDeclaration().getType()) && oldValue != null && newValue != null && !TypeQueries.sameTypes((IDatatype)oldValue.getType(), (IDatatype)newValue.getType())) {
            result = true;
        }
        return result;
    }

    private void rescheduleConstraintsForParent(IDecisionVariable variable) {
        IConfigurationElement parent = variable.getParent();
        if (parent instanceof IDecisionVariable) {
            IDecisionVariable pVar = (IDecisionVariable)parent;
            this.resolver.reschedule(pVar.getDeclaration());
            this.rescheduleConstraintsForParent(pVar);
        }
    }

    private void rescheduleConstraintsForChilds(IDecisionVariable variable, boolean decl) {
        if (decl) {
            this.resolver.reschedule(variable.getDeclaration());
        } else {
            this.resolver.reschedule(variable);
        }
        int j = 0;
        int nChilds = variable.getNestedElementsCount();
        while (j < nChilds) {
            this.rescheduleConstraintsForChilds(variable.getNestedElement(j), decl);
            ++j;
        }
    }
}

