/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.reasoning.sseReasoner.functions.FailedElementDetails;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;

public class FailedElements {
    private Map<Constraint, FailedElementDetails> problemConstraints = new HashMap<Constraint, FailedElementDetails>();
    private Map<Constraint, List<EvaluationVisitor.Message>> problemMessages;
    private Map<AbstractVariable, FailedElementDetails> problemVariables = new HashMap<AbstractVariable, FailedElementDetails>();
    private List<EvaluationVisitor.Message> messages;

    public FailedElements() {
        this.problemMessages = new HashMap<Constraint, List<EvaluationVisitor.Message>>();
        this.messages = new ArrayList<EvaluationVisitor.Message>();
    }

    public void addProblemConstraint(Constraint constraint, FailedElementDetails details) {
        this.problemConstraints.put(constraint, details);
    }

    public void removeProblemConstraint(Constraint constraint) {
        this.problemConstraints.remove(constraint);
        List<EvaluationVisitor.Message> msg = this.problemMessages.get(constraint);
        if (msg != null) {
            this.messages.removeAll(msg);
        }
    }

    public void addMessage(Constraint constraint, EvaluationVisitor.Message message) {
        this.messages.add(message);
        List<EvaluationVisitor.Message> msg = this.problemMessages.get(constraint);
        if (msg == null) {
            msg = new LinkedList<EvaluationVisitor.Message>();
            this.problemMessages.put(constraint, msg);
        }
        msg.add(message);
    }

    public void removeProblemConstraints(List<Constraint> constraints) {
        int c = 0;
        int n = constraints.size();
        while (c < n) {
            this.problemConstraints.remove(constraints.get(c));
            ++c;
        }
    }

    public void addProblemVariable(AbstractVariable variable, FailedElementDetails details) {
        this.problemVariables.put(variable, details);
    }

    public boolean hasProblems() {
        boolean messageProblem = false;
        int m = 0;
        while (!messageProblem && m < this.messages.size()) {
            messageProblem = this.messages.get(m).getStatus() == Status.ERROR;
            ++m;
        }
        return messageProblem || !this.problemConstraints.isEmpty() || !this.problemVariables.isEmpty();
    }

    public int problemCount() {
        return this.problemConstraintCount() + this.problemVariabletCount();
    }

    public int problemConstraintCount() {
        return this.problemConstraints.size();
    }

    public int problemVariabletCount() {
        return this.problemVariables.size();
    }

    public Iterator<Constraint> getProblemConstraints() {
        return this.problemConstraints.keySet().iterator();
    }

    public Map<Constraint, FailedElementDetails> getProblemConstraintMap() {
        return this.problemConstraints;
    }

    public Iterator<AbstractVariable> getProblemVariables() {
        return this.problemVariables.keySet().iterator();
    }

    public Iterator<EvaluationVisitor.Message> getMessages() {
        return this.messages.iterator();
    }

    public Map<AbstractVariable, FailedElementDetails> getProblemVariableMap() {
        return this.problemVariables;
    }

    public void clear() {
        this.problemConstraints.clear();
        this.problemVariables.clear();
        this.problemMessages.clear();
        this.messages.clear();
    }
}

