/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.ContainerVariable;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.VariableCreator;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.FreezeEvaluator;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.FreezeVariableType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class VariableValueCopier {
    private Map<IDatatype, Map<String, CopySpec>> specs = new HashMap<IDatatype, Map<String, CopySpec>>();
    private String namePrefix;
    private int count;
    private IAssignmentState newState;
    private IAssignmentListener listener;

    public VariableValueCopier(String namePrefix, CopySpec ... copySpecs) {
        this(namePrefix, AssignmentState.ASSIGNED, copySpecs);
    }

    public VariableValueCopier(String namePrefix, IAssignmentState newState, CopySpec ... copySpecs) {
        this.namePrefix = namePrefix;
        this.newState = newState == null ? AssignmentState.ASSIGNED : newState;
        int c = 0;
        while (c < copySpecs.length) {
            CopySpec spec = copySpecs[c];
            if (spec != null) {
                if (spec.isValid()) {
                    Map<String, CopySpec> map = this.specs.get(spec.getType());
                    if (map == null) {
                        map = new HashMap<String, CopySpec>();
                        this.specs.put(spec.getType(), map);
                    }
                    map.put(spec.getSourceVariableName(), spec);
                } else {
                    this.getLogger().warn("no type/source/target given for spec " + c + ". Ignoring.");
                }
            } else {
                this.getLogger().warn("no type/source/target given for spec " + c + ". Ignoring.");
            }
            ++c;
        }
    }

    public void setAssignmentListener(IAssignmentListener listener) {
        this.listener = listener;
    }

    protected EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.varModel");
    }

    public void process(Configuration config) throws ConfigurationException, ValueDoesNotMatchTypeException, CSTSemanticException {
        Iterator<IDecisionVariable> iter = config.iterator();
        ArrayList<IDecisionVariable> tmp = new ArrayList<IDecisionVariable>(config.getDecisionCount());
        while (iter.hasNext()) {
            tmp.add(iter.next());
        }
        int t = 0;
        while (t < tmp.size()) {
            IDecisionVariable srcVar = (IDecisionVariable)tmp.get(t);
            Map<String, CopySpec> fieldSpecs = this.specs.get(srcVar.getDeclaration().getType());
            if (fieldSpecs != null) {
                this.process(srcVar, srcVar, "", fieldSpecs, new HashSet<IDecisionVariable>());
            }
            ++t;
        }
    }

    private void process(IDecisionVariable variable, IDecisionVariable base, String prefix, Map<String, CopySpec> fieldSpecs, Set<IDecisionVariable> done) throws ConfigurationException, ValueDoesNotMatchTypeException, CSTSemanticException {
        if (!done.contains(variable)) {
            done.add(variable);
            int n = 0;
            while (n < variable.getNestedElementsCount()) {
                IDecisionVariable target;
                String[] names;
                CopySpec spec;
                IDecisionVariable nested = variable.getNestedElement(n);
                Object name = nested.getDeclaration().getName();
                if (prefix.length() > 0) {
                    name = prefix + "." + (String)name;
                }
                if ((spec = fieldSpecs.get(name)) != null && (names = spec.getTargetVariableNames()).length >= 1 && (target = VariableValueCopier.findVariable(base, names[0])) != null) {
                    Value value = this.copy(nested, target, spec.getFreezeProvider());
                    this.handleFurther(base, names, value);
                }
                this.process(Configuration.dereference(nested), base, (String)name, fieldSpecs, done);
                ++n;
            }
        }
    }

    private void handleFurther(IDecisionVariable base, String[] names, Value value) throws ConfigurationException {
        IDatatype valueType;
        IDatatype iDatatype = valueType = value == null ? null : value.getType();
        if (valueType != null && Reference.TYPE.isAssignableFrom(valueType)) {
            valueType = Reference.dereference(valueType);
            int t = 1;
            while (t < names.length) {
                IDecisionVariable further = VariableValueCopier.findVariable(base, names[t]);
                if (further != null && Reference.TYPE.isAssignableFrom(further.getDeclaration().getType())) {
                    if (Container.TYPE.isAssignableFrom(valueType)) {
                        ContainerValue cValue = (ContainerValue)value;
                        if (cValue.getElementSize() > 0) {
                            further.setValue(cValue.getElement(0), this.newState);
                        }
                    } else {
                        further.setValue(value, this.newState);
                    }
                }
                ++t;
            }
        }
    }

    public static IDecisionVariable findVariable(IDecisionVariable base, String qname) {
        String restName;
        String searchName;
        int pos = qname.indexOf(46);
        if (pos > 0) {
            searchName = qname.substring(0, pos);
            restName = qname.substring(pos + 1);
        } else {
            searchName = qname;
            restName = null;
        }
        IDecisionVariable result = null;
        int n = 0;
        while (result == null && n < base.getNestedElementsCount()) {
            IDecisionVariable nested = base.getNestedElement(n);
            if (nested.getDeclaration().getName().equals(searchName)) {
                result = nested;
            }
            ++n;
        }
        if (result != null && restName != null) {
            result = VariableValueCopier.findVariable(result, restName);
        }
        return result;
    }

    private Value copy(IDecisionVariable source, IDecisionVariable target, IFreezeProvider freezeProvider) throws ConfigurationException, ValueDoesNotMatchTypeException, CSTSemanticException {
        Value result = null;
        source = Configuration.dereference(source);
        target = Configuration.dereference(target);
        IDatatype sourceType = source.getDeclaration().getType();
        IDatatype targetType = target.getDeclaration().getType();
        if (Container.TYPE.isAssignableFrom(sourceType)) {
            if (Container.TYPE.isAssignableFrom(targetType)) {
                ContainerVariable cVar = this.ensureContainerVariable((ContainerVariable)target);
                int n = 0;
                while (n < source.getNestedElementsCount()) {
                    IDecisionVariable nestedVar = cVar.addNestedElement();
                    result = VariableValueCopier.keepFirst(result, this.copySingleVariable(source.getNestedElement(n), nestedVar, freezeProvider, true));
                    ++n;
                }
            } else {
                ContainerVariable sVar = (ContainerVariable)source;
                if (sVar.getNestedElementsCount() > 0) {
                    result = VariableValueCopier.keepFirst(result, this.copySingleVariable(sVar.getNestedElement(0), target, freezeProvider, false));
                }
            }
        } else if (Container.TYPE.isAssignableFrom(targetType)) {
            ContainerVariable cVar = this.ensureContainerVariable((ContainerVariable)target);
            IDecisionVariable tgt = cVar.addNestedElement();
            result = VariableValueCopier.keepFirst(result, this.copySingleVariable(source, tgt, freezeProvider, true));
        } else {
            result = VariableValueCopier.keepFirst(result, this.copySingleVariable(source, target, freezeProvider, false));
        }
        return result;
    }

    private static Value keepFirst(Value actual, Value newValue) {
        return actual == null ? newValue : actual;
    }

    private ContainerVariable ensureContainerVariable(ContainerVariable target) throws ConfigurationException, ValueDoesNotMatchTypeException {
        if (AssignmentState.UNDEFINED == target.getState()) {
            target.setValue(ValueFactory.createValue(target.getDeclaration().getType(), ValueFactory.EMPTY), this.newState);
        }
        return target;
    }

    public static boolean doCreateNewVars(String namePrefix) {
        return namePrefix != null && namePrefix.length() > 0;
    }

    private Value copySingleVariable(IDecisionVariable source, IDecisionVariable target, IFreezeProvider freezeProvider, boolean adding) throws ConfigurationException, ValueDoesNotMatchTypeException, CSTSemanticException {
        Value result = null;
        Value sValue = (source = Configuration.dereference(source)).getValue();
        if (sValue instanceof ReferenceValue && ((ReferenceValue)sValue).getValue() == null) {
            sValue = null;
        }
        if (sValue != null) {
            boolean createNew = VariableValueCopier.doCreateNewVars(this.namePrefix);
            IDatatype targetType = target.getDeclaration().getType();
            Value value = Reference.TYPE.isAssignableFrom(targetType) && !createNew ? ValueFactory.createValue(targetType, source.getDeclaration()) : source.getValue().clone();
            if (Reference.TYPE.isAssignableFrom(targetType) && createNew) {
                Configuration cfg = source.getConfiguration();
                Project prj = cfg.getProject();
                IModelElement topParent = source.getDeclaration().getTopLevelParent();
                if (topParent instanceof Project) {
                    prj = (Project)topParent;
                }
                DecisionVariableDeclaration decl = new DecisionVariableDeclaration(this.namePrefix + "_" + source.getDeclaration().getName() + "_" + this.count++, source.getDeclaration().getType(), prj);
                prj.add(decl);
                IDecisionVariable var = cfg.createDecision(decl);
                if (var != null) {
                    this.notifyCreated(source, var);
                    var.setValue(value, this.newState);
                    this.doFreeze(freezeProvider, cfg, var, decl);
                    result = ValueFactory.createValue(targetType, decl);
                    target.setValue(result, this.newState);
                    this.notifyAssigned(target, result, adding);
                } else {
                    IModelElement parent = decl.getParent();
                    String parentType = parent != null ? decl.getParent().getClass().getSimpleName() : "<no type>";
                    this.getLogger().error("Cannot create variable instance for " + decl.getName() + " of " + source.getDeclaration().getName() + " with:\n - Parent = " + String.valueOf(parent) + "(" + parentType + ")\n - Existing instance (should be null): " + String.valueOf(cfg.getDecision(decl)));
                }
            } else {
                target.setValue(value, this.newState);
                this.notifyAssigned(target, value, adding);
                result = value;
            }
        }
        return result;
    }

    private void doFreeze(IFreezeProvider freezeProvider, Configuration cfg, IDecisionVariable var, IFreezable freezable) throws ValueDoesNotMatchTypeException, CSTSemanticException {
        if (freezeProvider != null) {
            IFreezeSelector fsel = freezeProvider.getSelector();
            if (fsel == null) {
                Project prj = cfg.getProject();
                IFreezable[] freezables = new IFreezable[]{freezable};
                FreezeVariableType iterType = new FreezeVariableType(freezables, (IModelElement)prj);
                DecisionVariableDeclaration freezeIter = new DecisionVariableDeclaration(freezeProvider.getFreezeVariableName(), iterType, prj);
                ConstraintSyntaxTree selector = freezeProvider.createButExpression(freezeIter);
                selector.inferDatatype();
                FreezeBlock freeze = new FreezeBlock(freezables, freezeIter, selector, prj);
                prj.add(freeze);
                FreezeEvaluator evaluator = new FreezeEvaluator(cfg);
                evaluator.setFreeze(freeze);
                fsel = evaluator;
            }
            var.freeze(fsel);
        }
    }

    private void notifyAssigned(IDecisionVariable target, Value value, boolean added) {
        if (this.listener != null) {
            this.listener.notifyAssigned(target, value, added);
        }
    }

    private void notifyCreated(IDecisionVariable origin, IDecisionVariable target) {
        if (this.listener != null) {
            this.listener.notifyCreated(origin, target);
        }
    }

    static IDecisionVariable copy(IDecisionVariable variable, String namePrefix) throws CSTSemanticException, ValueDoesNotMatchTypeException, ConfigurationException {
        VariableValueCopier copier = new VariableValueCopier(namePrefix, new CopySpec[0]);
        AbstractVariable decl = variable.getDeclaration();
        VariableCreator creator = new VariableCreator(decl, variable.getParent(), variable.isVisible(), decl.isAttribute());
        IDecisionVariable result = creator.getVariable();
        copier.copy(variable, result, new SourceBasedFreezeProvider(variable, result));
        return result;
    }

    public static class CopySpec {
        private Compound type;
        private String sourceVariableName;
        private IFreezeProvider freezeProvider;
        private String[] targetVariableNames;

        public CopySpec(Compound type, String sourceVariableName, String ... targetVariableNames) {
            this(type, sourceVariableName, (IFreezeProvider)null, targetVariableNames);
        }

        public CopySpec(Compound type, String sourceVariableName, IFreezeProvider freezeProvider, String ... targetVariableNames) {
            this.type = type;
            this.sourceVariableName = sourceVariableName;
            this.freezeProvider = freezeProvider;
            this.targetVariableNames = targetVariableNames;
        }

        public Compound getType() {
            return this.type;
        }

        public String getSourceVariableName() {
            return this.sourceVariableName;
        }

        public IFreezeProvider getFreezeProvider() {
            return this.freezeProvider;
        }

        public String[] getTargetVariableNames() {
            return this.targetVariableNames;
        }

        public boolean isValid() {
            return this.type != null && this.sourceVariableName != null && this.targetVariableNames != null;
        }
    }

    public static class EnumAttributeFreezeProvider
    implements IFreezeProvider {
        private String name;
        private String operation;
        private Attribute annotation;
        private EnumLiteral literal;

        public EnumAttributeFreezeProvider(String name, Attribute annotation, EnumLiteral literal) {
            this(name, annotation, "==", literal);
        }

        public EnumAttributeFreezeProvider(String name, Attribute annotation, String operation, EnumLiteral literal) {
            this.name = name;
            this.operation = operation;
            this.annotation = annotation;
            this.literal = literal;
        }

        @Override
        public String getFreezeVariableName() {
            return this.name;
        }

        private Attribute findAttribute(Project prj, String name, Set<Project> done) {
            Attribute result = null;
            if (!done.contains(prj)) {
                done.add(prj);
                result = prj.getAttribute(name);
                int i = 0;
                while (result == null && i < prj.getImportsCount()) {
                    Project p = (Project)prj.getImport(i).getResolved();
                    if (p != null) {
                        result = this.findAttribute(p, name, done);
                    }
                    ++i;
                }
            }
            return result;
        }

        @Override
        public ConstraintSyntaxTree createButExpression(DecisionVariableDeclaration freezeIter) throws CSTSemanticException, ValueDoesNotMatchTypeException {
            OCLFeatureCall selector = null;
            FreezeVariableType iterType = (FreezeVariableType)freezeIter.getType();
            IModelElement par = iterType.getTopLevelParent();
            String annotationName = this.annotation.getName();
            Attribute attr = this.annotation.getParent() == par ? this.annotation : iterType.getAttribute(this.annotation.getName());
            while (attr == null && par instanceof Project) {
                attr = this.findAttribute((Project)par, annotationName, new HashSet<Project>());
            }
            if (attr != null) {
                AttributeVariable iterEx = new AttributeVariable(new Variable(freezeIter), attr);
                selector = new OCLFeatureCall((ConstraintSyntaxTree)iterEx, this.operation, new ConstantValue(ValueFactory.createValue(this.annotation.getType(), this.literal)));
            } else {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.varModel").error("cannot create freeze selector as annotation " + annotationName + " cannot be found");
            }
            return selector;
        }

        @Override
        public IFreezeSelector getSelector() {
            return null;
        }
    }

    public static interface IAssignmentListener {
        public void notifyAssigned(IDecisionVariable var1, Value var2, boolean var3);

        public void notifyCreated(IDecisionVariable var1, IDecisionVariable var2);
    }

    public static interface IFreezeProvider {
        public String getFreezeVariableName();

        public ConstraintSyntaxTree createButExpression(DecisionVariableDeclaration var1) throws CSTSemanticException, ValueDoesNotMatchTypeException;

        public IFreezeSelector getSelector();
    }

    private static class SourceBasedFreezeProvider
    implements IFreezeProvider,
    IFreezeSelector {
        private IDecisionVariable source;
        private IDecisionVariable target;

        private SourceBasedFreezeProvider(IDecisionVariable source, IDecisionVariable target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public String getFreezeVariableName() {
            return null;
        }

        @Override
        public ConstraintSyntaxTree createButExpression(DecisionVariableDeclaration freezeIter) throws CSTSemanticException, ValueDoesNotMatchTypeException {
            return null;
        }

        @Override
        public IFreezeSelector getSelector() {
            return this;
        }

        @Override
        public boolean shallFreeze(IDecisionVariable variable) {
            boolean freeze = false;
            IDecisionVariable sVar = this.findCorrespondence(variable);
            if (sVar != null) {
                freeze = AssignmentState.FROZEN == sVar.getState();
            }
            return freeze;
        }

        private IDecisionVariable findCorrespondence(IDecisionVariable tVar) {
            IDecisionVariable sVar;
            IDecisionVariable result = null;
            if (tVar.getParent() == this.target) {
                result = this.source.getNestedElement(tVar.getDeclaration().getName());
            } else if (tVar.getParent() instanceof IDecisionVariable && (sVar = this.findCorrespondence((IDecisionVariable)tVar.getParent())) != null) {
                result = sVar.getNestedElement(tVar.getDeclaration().getName());
            }
            return result;
        }
    }
}

