/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DelegatingType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.Set;

public class Sequence
extends Container {
    static final DelegatingType DTYPE = AnyType.SEQUENCE_TYPE;
    public static final IDatatype TYPE = DTYPE;
    public static final Operation INDEX_ACCESS = new Operation(AnyType.TYPE, Operation.ReturnTypeMode.GENERIC_PARAM_1, "[]", TYPE, IntegerType.TYPE);
    public static final Operation AT = new Operation(AnyType.TYPE, Operation.ReturnTypeMode.GENERIC_PARAM_1, "at", TYPE, IntegerType.TYPE);
    public static final Operation FIRST = new Operation(AnyType.TYPE, Operation.ReturnTypeMode.GENERIC_PARAM_1, "first", TYPE, new IDatatype[0]);
    public static final Operation LAST = new Operation(AnyType.TYPE, Operation.ReturnTypeMode.GENERIC_PARAM_1, "last", TYPE, new IDatatype[0]);
    public static final Operation AS_SET = new Operation(Set.TYPE, Operation.ReturnTypeMode.TYPED_OPERAND_1, "asSet", TYPE, new IDatatype[0]);
    public static final Operation TO_SET = new Operation(Set.TYPE, Operation.ReturnTypeMode.TYPED_OPERAND_1, "toSet", TYPE, new IDatatype[0]);
    public static final Operation AS_SEQUENCE = new Operation(TYPE, Operation.ReturnTypeMode.TYPED_OPERAND_1, "asSequence", TYPE, new IDatatype[0]);
    public static final Operation TO_SEQUENCE = new Operation(TYPE, Operation.ReturnTypeMode.TYPED_OPERAND_1, "toSequence", TYPE, new IDatatype[0]);
    public static final Operation UNION = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "union", TYPE, TYPE);
    public static final Operation APPEND = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "append", TYPE, AnyType.TYPE);
    public static final Operation PREPEND = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "prepend", TYPE, AnyType.TYPE);
    public static final Operation INSERT_AT = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "insertAt", TYPE, IntegerType.TYPE, AnyType.TYPE);
    public static final Operation INDEX_OF = new Operation(IntegerType.TYPE, "indexOf", TYPE, AnyType.TYPE);
    public static final Operation HAS_DUPLICATES = new Operation(BooleanType.TYPE, "hasDuplicates", TYPE, new IDatatype[0]);
    public static final Operation EXCLUDING = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "excluding", TYPE, AnyType.TYPE);
    public static final Operation INCLUDING = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "including", TYPE, AnyType.TYPE);
    public static final Operation REVERSE = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "reverse", TYPE, new IDatatype[0]);
    public static final Operation SUBSEQUENCE = new Operation(TYPE, Operation.ReturnTypeMode.TYPED_OPERAND_1, "subSequence", TYPE, IntegerType.TYPE, IntegerType.TYPE);
    public static final Operation ADD = new Operation(AnyType.TYPE, Operation.ReturnTypeMode.PARAM_1_CHECK, "add", TYPE, AnyType.TYPE);
    public static final Operation ISSUBSEQUENCE = new Operation(BooleanType.TYPE, "isSubsequenceOf", TYPE, TYPE);
    public static final Operation OVERLAPS = new Operation(BooleanType.TYPE, "overlaps", TYPE, TYPE);
    public static final Operation FLATTEN = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND_COLLECTION_NESTED_GENERIC_1, "flatten", TYPE, new IDatatype[0]);
    public static final Operation EQUALS = Operation.createInfixOperator(BooleanType.TYPE, "==", TYPE, TYPE).markAsAssignableParameterOperation();
    public static final Operation ASSIGNMENT = Operation.createInfixOperator(BooleanType.TYPE, "=", TYPE, TYPE);

    static {
        DTYPE.setDelegate(new Sequence());
        DTYPE.addOperation(INDEX_ACCESS);
        DTYPE.addOperation(AT);
        DTYPE.addOperation(FIRST);
        DTYPE.addOperation(LAST);
        DTYPE.addOperation(EQUALS);
        DTYPE.addOperation(ASSIGNMENT);
        DTYPE.addOperation(AS_SET);
        DTYPE.addOperation(TO_SET);
        DTYPE.addOperation(AS_SEQUENCE);
        DTYPE.addOperation(TO_SEQUENCE);
        DTYPE.addOperation(UNION);
        DTYPE.addOperation(APPEND);
        DTYPE.addOperation(PREPEND);
        DTYPE.addOperation(INSERT_AT);
        DTYPE.addOperation(INDEX_OF);
        DTYPE.addOperation(HAS_DUPLICATES);
        DTYPE.addOperation(INCLUDING);
        DTYPE.addOperation(EXCLUDING);
        DTYPE.addOperation(REVERSE);
        DTYPE.addOperation(SUBSEQUENCE);
        DTYPE.addOperation(ADD);
        DTYPE.addOperation(ISSUBSEQUENCE);
        DTYPE.addOperation(OVERLAPS);
        DTYPE.addOperation(FLATTEN);
    }

    private Sequence() {
        this("<Sequence>", (IDatatype)null, (IModelElement)null);
    }

    public Sequence(String name, IDatatype type, IModelElement parent) {
        super(name, DTYPE, type, parent);
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visitSequence(this);
    }

    @Override
    public void accept(IDatatypeVisitor visitor) {
        visitor.visitSequence(this);
    }

    public static final boolean isSequence(IDatatype type, IDatatype ... generics) {
        return Sequence.isType(TYPE, type, generics);
    }
}

