/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DelegatingType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.Sequence;

public class Set
extends Container {
    static final DelegatingType DTYPE = AnyType.SET_TYPE;
    public static final IDatatype TYPE = DTYPE;
    public static final Operation AS_SET = new Operation(TYPE, Operation.ReturnTypeMode.TYPED_OPERAND_1, "asSet", TYPE, new IDatatype[0]);
    public static final Operation TO_SET = new Operation(TYPE, Operation.ReturnTypeMode.TYPED_OPERAND_1, "toSet", TYPE, new IDatatype[0]);
    public static final Operation AS_SEQUENCE = new Operation(Sequence.TYPE, Operation.ReturnTypeMode.TYPED_OPERAND_1, "asSequence", TYPE, new IDatatype[0]);
    public static final Operation TO_SEQUENCE = new Operation(Sequence.TYPE, Operation.ReturnTypeMode.TYPED_OPERAND_1, "toSequence", TYPE, new IDatatype[0]);
    public static final Operation UNION = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "union", TYPE, TYPE);
    public static final Operation INTERSECTION = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "intersection", TYPE, TYPE);
    public static final Operation EXCLUDING = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "excluding", TYPE, AnyType.TYPE);
    public static final Operation INCLUDING = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "including", TYPE, AnyType.TYPE);
    public static final Operation DIFFERENCE = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "-", TYPE, AnyType.TYPE).markByFormattingHint(Operation.FormattingHint.OPERATOR_INFIX);
    public static final Operation SYMMETRIC_DIFFERENCE = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "symmetricDifference", TYPE, AnyType.TYPE);
    public static final Operation ADD = new Operation(AnyType.TYPE, Operation.ReturnTypeMode.PARAM_1_CHECK, "add", TYPE, AnyType.TYPE);
    public static final Operation FLATTEN = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND_COLLECTION_NESTED_GENERIC_1, "flatten", TYPE, new IDatatype[0]);
    public static final Operation EQUALS = Operation.createInfixOperator(BooleanType.TYPE, "==", TYPE, TYPE).markAsAssignableParameterOperation();
    public static final Operation ASSIGNMENT = Operation.createInfixOperator(BooleanType.TYPE, "=", TYPE, TYPE);

    static {
        DTYPE.setDelegate(new Set());
        DTYPE.addOperation(EQUALS);
        DTYPE.addOperation(ASSIGNMENT);
        DTYPE.addOperation(AS_SET);
        DTYPE.addOperation(TO_SET);
        DTYPE.addOperation(AS_SEQUENCE);
        DTYPE.addOperation(TO_SEQUENCE);
        DTYPE.addOperation(UNION);
        DTYPE.addOperation(INTERSECTION);
        DTYPE.addOperation(EXCLUDING);
        DTYPE.addOperation(INCLUDING);
        DTYPE.addOperation(DIFFERENCE);
        DTYPE.addOperation(SYMMETRIC_DIFFERENCE);
        DTYPE.addOperation(ADD);
        DTYPE.addOperation(FLATTEN);
    }

    private Set() {
        this("<Set>", (IDatatype)null, (IModelElement)null);
    }

    public Set(String name, IDatatype type, IModelElement parent) {
        super(name, DTYPE, type, parent);
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visitSet(this);
    }

    @Override
    public void accept(IDatatypeVisitor visitor) {
        visitor.visitSet(this);
    }

    public static final boolean isSet(IDatatype type, IDatatype ... generics) {
        return Set.isType(TYPE, type, generics);
    }
}

