/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.filter;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.filter.AbstractVariableInConstraintFinder;

public abstract class AbstractStateVariablesInConstraintFinder
extends AbstractVariableInConstraintFinder {
    private Configuration config;
    private EvaluationVisitor evaluator = new EvaluationVisitor();

    public AbstractStateVariablesInConstraintFinder() {
        super(false);
        this.clear();
    }

    public AbstractStateVariablesInConstraintFinder(ConstraintSyntaxTree cst, Configuration config) {
        this();
        this.setConfiguration(config);
        cst.accept(this);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.evaluator.init(config, null, false, null);
    }

    public void clear() {
        this.evaluator.clear();
    }

    @Override
    public void visitVariable(Variable variable) {
        this.addVariable(variable.getVariable());
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        ConstraintSyntaxTree qu = variable.getQualifier();
        if (qu != null) {
            qu.accept(this);
        }
        this.visitVariable(variable);
    }

    @Override
    protected void addVariable(AbstractVariable declaration) {
        this.addVariable(this.config.getDecision(declaration));
    }

    protected abstract void addVariable(IDecisionVariable var1);

    @Override
    public void visitLet(Let let) {
        this.addVariable(let.getVariable());
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        call.getContainer().accept(this);
        call.getExpression().accept(this);
        int i = 0;
        while (i < call.getDeclaratorsCount()) {
            this.addVariable(call.getDeclarator(i));
            ++i;
        }
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        try {
            access.inferDatatype();
        }
        catch (CSTSemanticException e) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.varModel").exception((Exception)e);
        }
        access.accept(this.evaluator);
        this.addVariable(this.evaluator.getResultVariable());
        this.evaluator.clearResult();
    }

    protected EvaluationVisitor getEvaluator() {
        return this.evaluator;
    }

    protected Configuration getConfiguration() {
        return this.config;
    }
}

