/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.filter;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;

public class ConstraintFinder
implements IModelVisitor {
    private List<Constraint> constraints = new ArrayList<Constraint>();
    private List<Constraint> evalConstraints = new ArrayList<Constraint>();
    private boolean considerImports;
    private boolean excludeAssignments;
    private boolean isEvalConstraint;
    private boolean handleEvals;
    private List<AttributeAssignment> allAttributes;

    public ConstraintFinder(Project project) {
        this(project, true);
    }

    public ConstraintFinder(Project project, boolean considerImports) {
        this(project, considerImports, false);
    }

    public ConstraintFinder(Project project, boolean considerImports, boolean excludeAssignments) {
        this(project, considerImports, false, false);
    }

    public ConstraintFinder(Project project, boolean considerImports, boolean excludeAssignments, boolean handleEvals) {
        this.considerImports = considerImports;
        this.excludeAssignments = excludeAssignments;
        this.allAttributes = new ArrayList<AttributeAssignment>();
        this.handleEvals = handleEvals;
        this.isEvalConstraint = false;
        this.startAccept(project);
    }

    protected void startAccept(Project project) {
        project.accept(this);
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public List<Constraint> getEvalConstraints() {
        return this.evalConstraints;
    }

    public List<AttributeAssignment> getAttributeAssignments() {
        return this.allAttributes;
    }

    @Override
    public void visitEnum(Enum eenum) {
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
    }

    @Override
    public void visitCompound(Compound compound) {
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
        int v = 0;
        while (v < assignment.getConstraintsCount()) {
            assignment.getConstraint(v).accept(this);
            ++v;
        }
        int a = 0;
        while (a < assignment.getAssignmentCount()) {
            assignment.getAssignment(a).accept(this);
            ++a;
        }
        this.allAttributes.add(assignment);
    }

    @Override
    public void visitDerivedDatatype(DerivedDatatype datatype) {
    }

    @Override
    public void visitEnumLiteral(EnumLiteral literal) {
    }

    @Override
    public void visitReference(Reference reference) {
    }

    @Override
    public void visitSequence(Sequence sequence) {
    }

    @Override
    public void visitSet(Set set) {
    }

    @Override
    public void visitProject(Project project) {
        int i;
        if (this.considerImports) {
            i = 0;
            while (i < project.getImportsCount()) {
                project.getImport(i).accept(this);
                ++i;
            }
        }
        i = 0;
        while (i < project.getElementCount()) {
            project.getElement(i).accept(this);
            ++i;
        }
    }

    @Override
    public void visitProjectImport(ProjectImport pImport) {
        if (pImport.isResolved()) {
            ((Project)pImport.getResolved()).accept(this);
        }
    }

    @Override
    public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public void visitConstraint(Constraint constraint) {
        boolean add = true;
        ConstraintSyntaxTree cst = constraint.getConsSyntax();
        if (this.excludeAssignments && cst instanceof OCLFeatureCall) {
            OCLFeatureCall call = (OCLFeatureCall)cst;
            boolean bl = add = !"=".equals(call.getOperation());
        }
        if (add) {
            if (this.isEvalConstraint && this.handleEvals) {
                this.evalConstraints.add(constraint);
            } else {
                this.constraints.add(constraint);
            }
        }
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
    }

    @Override
    public void visitOperationDefinition(OperationDefinition opdef) {
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        int i = 0;
        while (i < block.getNestedCount()) {
            block.getNested(i).accept(this);
            ++i;
        }
        this.isEvalConstraint = true;
        i = 0;
        while (i < block.getEvaluableCount()) {
            block.getEvaluable(i).accept(this);
            ++i;
        }
        this.isEvalConstraint = false;
    }

    @Override
    public void visitProjectInterface(ProjectInterface iface) {
    }

    @Override
    public void visitComment(Comment comment) {
    }

    @Override
    public void visitCompoundAccessStatement(CompoundAccessStatement access) {
    }
}

