/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.filter;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.filter.AbstractVariableInConstraintFinder;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;

public class IDecisionVariableInConstraintFinder
extends AbstractVariableInConstraintFinder {
    private Configuration config;
    private Deque<IDecisionVariable> parents;
    private IDecisionVariable lastVariable;
    private Set<IDecisionVariable> variables;

    public IDecisionVariableInConstraintFinder(Configuration config) {
        super(true);
        this.config = config;
        this.parents = new ArrayDeque<IDecisionVariable>();
        this.lastVariable = null;
        this.variables = new HashSet<IDecisionVariable>();
    }

    public Set<IDecisionVariable> getVariables() {
        return this.variables;
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        ConstraintSyntaxTree qu = variable.getQualifier();
        if (qu != null) {
            qu.accept(this);
        }
        this.parents.addFirst(this.lastVariable);
        this.visitVariable(variable);
        this.parents.removeFirst();
    }

    @Override
    public void visitLet(Let let) {
        let.getInExpression().accept(this);
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        call.getContainer().accept(this);
        this.parents.addFirst(this.lastVariable);
        call.getExpression().accept(this);
        this.parents.removeFirst();
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        try {
            access.inferDatatype();
        }
        catch (CSTSemanticException e) {
            e.printStackTrace();
        }
        access.getCompoundExpression().accept(this);
        this.parents.addFirst(this.lastVariable);
        this.addVariable(access.getResolvedSlot());
        this.parents.removeFirst();
    }

    @Override
    protected void visitValue(Value value) {
        if (value != null) {
            if (value instanceof ContainerValue) {
                ContainerValue containerValue = (ContainerValue)value;
                int i = 0;
                while (i < containerValue.getElementSize()) {
                    this.visitValue(containerValue.getElement(i));
                    ++i;
                }
            } else if (value instanceof CompoundValue) {
                CompoundValue compoundValue = (CompoundValue)value;
                Compound cType = (Compound)compoundValue.getType();
                int i = 0;
                while (i < cType.getInheritedElementCount()) {
                    this.visitValue(compoundValue.getNestedValue(cType.getInheritedElement(i).getName()));
                    ++i;
                }
            } else if (value instanceof ReferenceValue) {
                ReferenceValue refValue = (ReferenceValue)value;
                this.addVariable(refValue.getValue());
            } else if (value instanceof IntValue && !this.parents.isEmpty()) {
                int index = ((IntValue)value).getValue();
                IDecisionVariable parent = this.parents.peekFirst();
                this.lastVariable = parent.getNestedElement(index);
                if (this.lastVariable != null) {
                    this.variables.add(this.lastVariable);
                }
            }
        }
    }

    @Override
    protected void addVariable(AbstractVariable declaration) {
        if (!this.parents.isEmpty()) {
            boolean found = false;
            IDecisionVariable parent = this.parents.peekFirst();
            int i = 0;
            int end = parent.getNestedElementsCount();
            while (i < end && !found) {
                IDecisionVariable nestedVariable = parent.getNestedElement(i);
                if (nestedVariable.getDeclaration() == declaration) {
                    this.lastVariable = nestedVariable;
                    this.variables.add(this.lastVariable);
                    found = true;
                }
                ++i;
            }
        } else {
            this.lastVariable = this.config.getDecision(declaration);
            if (this.lastVariable != null) {
                this.variables.add(this.lastVariable);
            }
        }
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        String op;
        if (call.getOperand() != null) {
            call.getOperand().accept(this);
        }
        if ("[]".equals(op = call.getOperation()) || "at".equals(op)) {
            this.parents.addFirst(this.lastVariable);
            int i = 0;
            while (i < call.getParameterCount()) {
                call.getParameter(i).accept(this);
                ++i;
            }
            this.parents.removeFirst();
        } else {
            int i = 0;
            while (i < call.getParameterCount()) {
                call.getParameter(i).accept(this);
                ++i;
            }
        }
    }
}

