/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.filter.mandatoryVars;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.filter.mandatoryVars.Importance;
import net.ssehub.easy.varModel.model.filter.mandatoryVars.MandatoryClassifierSettings;

public class VariableContainer {
    private Map<String, Importance> importances = new HashMap<String, Importance>();

    VariableContainer(Configuration config, MandatoryClassifierSettings settings) {
    }

    void setImportance(IDecisionVariable variable, Importance importance) {
        String qName = variable.getQualifiedName();
        this.setImportance(qName, importance);
    }

    void setImportance(String qName, Importance importance) {
        Importance oldImportance = this.importances.get(qName);
        if (Importance.OPTIONAL != oldImportance) {
            this.importances.put(qName, importance);
        }
    }

    public boolean isMandatory(IDecisionVariable variable) {
        boolean isMandatory = false;
        String qName = variable.getQualifiedName();
        Importance importance = this.importances.get(qName);
        boolean bl = isMandatory = Importance.MANDATORY == importance;
        if (!isMandatory) {
            isMandatory = this.hasMandatoryTypeOrParent(variable.getDeclaration());
        }
        return isMandatory;
    }

    public boolean isMandatory(AbstractVariable declaration) {
        boolean isMandatory = false;
        String qName = declaration.getQualifiedName();
        Importance importance = this.importances.get(qName);
        boolean bl = isMandatory = Importance.MANDATORY == importance;
        if (!isMandatory) {
            isMandatory = this.hasMandatoryTypeOrParent(declaration);
        }
        return isMandatory;
    }

    private boolean hasMandatoryTypeOrParent(AbstractVariable declaration) {
        boolean isMandatory = false;
        IModelElement parent = declaration.getParent();
        if (!(parent instanceof Project)) {
            String qName = parent.getQualifiedName() + "::" + declaration.getName();
            Importance importance = this.importances.get(qName);
            isMandatory = Importance.MANDATORY == importance;
        }
        return isMandatory;
    }

    public String toString() {
        return this.importances.toString();
    }
}

