/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.persistency;

import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CSTUtils;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.VersionValue;
import net.ssehub.easy.varModel.persistency.AbstractVarModelWriter;
import net.ssehub.easy.varModel.persistency.VariableUsage;
import org.apache.commons.lang.StringEscapeUtils;

public class IVMLWriter
extends AbstractVarModelWriter {
    private static final List<IVMLWriter> POOL = new ArrayList<IVMLWriter>();
    private Stack<Value> nestedValues = new Stack();
    private Stack<ConstraintSyntaxTree> nestedExpressions = new Stack();
    private Stack<OCLFeatureCall> callStack = new Stack();
    private boolean emitComments = true;
    private Stack<Comment> lastComment = new Stack();
    private java.util.Set<Attribute> handled = new HashSet<Attribute>();
    private VariableUsage variableUsage = new VariableUsage();
    private boolean formatInitializer = false;
    private boolean forceCompoundTypes = false;
    private DecisionVariableDeclaration inDecl;

    public IVMLWriter(Writer writer) {
        super(writer);
    }

    protected IVMLWriter(Writer writer, boolean emitComments) {
        this(writer);
        this.emitComments = emitComments;
    }

    public void setFormatInitializer(boolean formatInitializer) {
        this.formatInitializer = formatInitializer;
    }

    public void forceComponundTypes(boolean forceCompoundTypes) {
        this.forceCompoundTypes = forceCompoundTypes;
    }

    @Override
    public boolean emitComments() {
        return this.emitComments;
    }

    public static final synchronized IVMLWriter getInstance(Writer writer) {
        IVMLWriter result = POOL.size() > 0 ? POOL.remove(0) : new IVMLWriter(writer);
        result.setWriter(writer);
        return result;
    }

    public static final synchronized void releaseInstance(IVMLWriter writer) {
        assert (writer.getClass() == IVMLWriter.class);
        writer.setWriter(null);
        writer.emitComments = true;
        writer.lastComment.clear();
        writer.setIndentationStep(IVMLWriter.getIvmlIndentStep().length());
        writer.setUseWhitespaces(IVMLWriter.getUseIvmlWhitespace());
        POOL.add(writer);
    }

    @Override
    protected void printDefaultSpace(AbstractVarModelWriter.DefaultSpace location) {
        switch (location) {
            case PROJECT: {
                this.appendOutput("\r\n");
                this.appendOutput("\r\n");
                break;
            }
        }
    }

    @Override
    protected void startWritingProject(Project project) {
        Comment comment;
        if (this.emitComments && (comment = project.getNestedComment(project)) != null) {
            this.appendOutput(comment.getName());
        }
        this.appendOutput("project");
        this.appendOutput(" ");
        this.appendOutput(project.getName());
        this.appendOutput(" ");
        this.appendOutput("{");
    }

    @Override
    protected void endWritingProject(Project project) {
        this.appendOutput("}");
        this.appendOutput("\r\n");
    }

    @Override
    protected void processVersion(Version version) {
        this.appendIndentation();
        this.appendOutput("version");
        this.appendOutput(" ");
        this.appendOutput("v");
        this.appendOutput(version.getVersion());
        this.appendOutput(";");
        this.appendOutput("\r\n");
    }

    @Override
    public void visitProject(Project project) {
        project.accept(this.variableUsage);
        super.visitProject(project);
        this.variableUsage.clear();
    }

    @Override
    public void visitProjectImport(ProjectImport pImport) {
        IVersionRestriction restriction;
        this.appendIndentation();
        if (pImport.isConflict()) {
            this.appendOutput("conflicts");
        } else if (pImport.isInsert()) {
            this.appendOutput("insert");
        } else {
            this.appendOutput("import");
        }
        this.appendOutput(" ");
        this.appendOutput(pImport.getProjectName());
        if (pImport.getInterfaceName() != null && pImport.getInterfaceName().length() > 0) {
            this.appendOutput("::");
            this.appendOutput(pImport.getInterfaceName());
        }
        if ((restriction = pImport.getVersionRestriction()) != null) {
            this.appendOutput(" ");
            this.appendOutput("with");
            this.appendOutput(" ");
            this.appendOutput(restriction.toSpecification());
        }
        this.appendOutput(";");
        this.appendOutput("\r\n");
    }

    @Override
    protected void startWritingCompound(Compound compound) {
        if (compound.isAbstract()) {
            this.appendOutput("abstract");
            this.appendOutput(" ");
        }
        this.appendOutput("compound");
        this.appendOutput(" ");
        this.appendOutput(compound.getName());
        this.appendOutput(" ");
        int rCount = compound.getRefinesCount();
        if (rCount > 0) {
            this.appendOutput("refines");
            this.appendOutput(" ");
            int r = 0;
            while (r < rCount) {
                if (r > 0) {
                    this.appendOutput(",");
                    this.appendOutput(" ");
                }
                this.appendOutput(compound.getRefines(r).getUniqueName());
                ++r;
            }
            this.appendOutput(" ");
        }
        this.appendOutput("{");
        this.appendOutput("\r\n");
    }

    @Override
    protected void endWritingCompound(Compound compound) {
        this.appendOutput("}");
        this.appendOutput("\r\n\r\n");
    }

    @Override
    public void visitEnum(Enum eenum) {
        this.appendIndentation();
        this.appendOutput("enum");
        this.appendOutput(" ");
        this.appendOutput(eenum.getName());
        this.appendOutput(" ");
        this.appendOutput("{");
        int i = 0;
        while (i < eenum.getLiteralCount()) {
            if (i > 0) {
                this.appendOutput(",");
                this.appendOutput(" ");
            }
            this.appendOutput(eenum.getLiteral(i).getName());
            if (eenum.isOrdered()) {
                this.appendOutput(" ");
                this.appendOutput("=");
                this.appendOutput(" ");
                this.appendOutput(String.valueOf(eenum.getLiteral(i).getOrdinal()));
            }
            ++i;
        }
        this.appendOutput("}");
        this.appendOutput(";");
        this.appendOutput("\r\n");
    }

    @Override
    public void visitEnumValue(EnumValue value) {
        this.appendOutput(IvmlDatatypeVisitor.getUniqueType(value.getType()));
        if (IVMLWriter.considerOclCompliance()) {
            this.appendOutput("::");
        } else {
            this.appendOutput('.');
        }
        this.appendOutput(value.getValue().getName());
    }

    @Override
    public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
        this.appendIndentation();
        this.emitDecisionVariableDeclarationExpression(decl, null);
        this.appendOutput(";");
        this.appendOutput("\r\n");
    }

    private void emitDecisionVariableDeclarationExpression(DecisionVariableDeclaration decl, ConstraintSyntaxTree defaultValue) {
        this.inDecl = decl;
        if (decl.isConstant()) {
            this.appendOutput("const");
            this.appendOutput(" ");
        }
        this.appendOutput(IvmlDatatypeVisitor.getUniqueType(decl.getType()));
        this.appendOutput(" ");
        this.appendOutput(decl.getName());
        ConstraintSyntaxTree dflt = defaultValue;
        if (dflt == null) {
            dflt = decl.getDefaultValue();
        }
        if (dflt != null) {
            this.appendOutput(" ");
            this.appendOutput("=");
            this.appendOutput(" ");
            this.emitDecisionVariableDeclarationDefault(decl, dflt);
        }
        this.inDecl = null;
    }

    protected void emitDecisionVariableDeclarationDefault(DecisionVariableDeclaration decl, ConstraintSyntaxTree defaultValue) {
        this.setExpressionContext(decl);
        defaultValue.accept(this);
        this.setExpressionContext(null);
    }

    @Override
    public void visitStringValue(StringValue value) {
        String val = value.getValue();
        if (val != null) {
            this.appendOutput("\"");
            this.appendOutput(StringEscapeUtils.escapeJava((String)val));
            this.appendOutput("\"");
        }
    }

    private void emitType(IDatatype type, boolean considerValues) {
        Object implicitType = null;
        if (!this.forceCompoundTypes) {
            ConstraintSyntaxTree top;
            if (considerValues) {
                ConstraintSyntaxTree top2;
                if (!this.nestedValues.isEmpty()) {
                    Value top3 = this.nestedValues.peek();
                    if (top3 instanceof ContainerValue) {
                        Container container = (Container)((ContainerValue)top3).getType();
                        implicitType = container.getContainedType();
                    }
                } else if (!this.callStack.isEmpty() && CSTUtils.isAssignment(top2 = (ConstraintSyntaxTree)this.callStack.peek())) {
                    OCLFeatureCall call = (OCLFeatureCall)top2;
                    try {
                        implicitType = call.getOperand().inferDatatype();
                    }
                    catch (CSTSemanticException e) {
                        this.getLogger().exception((Exception)e);
                    }
                }
            } else if (!this.nestedExpressions.isEmpty() && (top = this.nestedExpressions.peek()) instanceof ContainerInitializer) {
                Container container = ((ContainerInitializer)top).getType();
                implicitType = container.getContainedType();
            }
            if (implicitType == null && this.inDecl != null) {
                implicitType = this.inDecl.getType();
            }
        }
        if (this.forceCompoundTypes || implicitType != null && !implicitType.equals(type)) {
            this.appendOutput(IvmlDatatypeVisitor.getUniqueType(type));
            this.appendOutput(" ");
        }
    }

    @Override
    public void visitCompoundValue(CompoundValue value) {
        this.emitType(value.getType(), true);
        this.nestedValues.push(value);
        this.appendOutput("{");
        if (this.formatInitializer) {
            this.appendOutput("\r\n");
            this.addParent(DUMMY_PARENT);
        }
        this.visitCompoundRefines((Compound)value.getType(), value, 0, new HashSet<String>());
        if (this.formatInitializer) {
            this.removeLastParent();
            this.appendOutput("\r\n");
            this.appendIndentation();
        }
        this.appendOutput("}");
        this.nestedValues.pop();
    }

    private int visitCompoundRefines(Compound comp, CompoundValue value, int count, java.util.Set<String> done) {
        count = this.visitCompoundDecisionVariableContainer(comp, value, count, done);
        int r = 0;
        while (r < comp.getRefinesCount()) {
            count = this.visitCompoundRefines(comp.getRefines(r), value, count, done);
            ++r;
        }
        return count;
    }

    protected boolean writeValue(Value value) {
        return true;
    }

    private int visitCompoundDecisionVariableContainer(IDecisionVariableContainer cont, CompoundValue value, int printed, java.util.Set<String> done) {
        int e = 0;
        while (e < cont.getElementCount()) {
            boolean emit;
            String name = cont.getElement(e).getName();
            if (done == null) {
                emit = true;
            } else {
                boolean bl = emit = !done.contains(name);
                if (emit) {
                    done.add(name);
                }
            }
            if (emit) {
                boolean isAbstract;
                Value nestedValue = value.getNestedValue(name);
                boolean bl = isAbstract = nestedValue != null && nestedValue.getType() instanceof Compound && ((Compound)nestedValue.getType()).isAbstract();
                if (nestedValue != null && !isAbstract && this.writeValue(nestedValue)) {
                    if (printed > 0) {
                        this.appendOutput(",");
                        this.appendOutput(" ");
                        if (this.formatInitializer) {
                            this.appendOutput("\r\n");
                        }
                    }
                    if (this.formatInitializer) {
                        this.appendIndentation();
                    }
                    this.appendOutput(name);
                    this.appendOutput(" ");
                    this.appendOutput("=");
                    this.appendOutput(" ");
                    nestedValue.accept(this);
                    ++printed;
                }
            }
            ++e;
        }
        int a = 0;
        while (a < cont.getAssignmentCount()) {
            printed = this.visitCompoundDecisionVariableContainer(cont.getAssignment(a), value, printed, done);
            ++a;
        }
        return printed;
    }

    @Override
    public void visitIntValue(IntValue value) {
        Integer val = value.getValue();
        if (val != null) {
            this.appendOutput(val.toString());
        }
    }

    @Override
    public void visitRealValue(RealValue value) {
        Double val = value.getValue();
        if (val != null) {
            this.appendOutput(val.toString());
        }
    }

    @Override
    public void visitBooleanValue(BooleanValue value) {
        Boolean val = value.getValue();
        if (val != null) {
            this.appendOutput(val.toString());
        }
    }

    @Override
    public void visitContainerValue(ContainerValue value) {
        this.nestedValues.push(value);
        this.appendOutput("{");
        if (this.formatInitializer && value.getElementSize() > 0) {
            this.appendOutput("\r\n");
            this.addParent(DUMMY_PARENT);
            this.appendIndentation();
        }
        int i = 0;
        while (i < value.getElementSize()) {
            if (i > 0) {
                this.appendOutput(",");
                this.appendOutput(" ");
            }
            value.getElement(i).accept(this);
            ++i;
        }
        if (this.formatInitializer && value.getElementSize() > 0) {
            this.removeLastParent();
            this.appendOutput("\r\n");
            this.appendIndentation();
        }
        this.appendOutput("}");
        this.nestedValues.pop();
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        this.emitType(initializer.getType(), false);
        this.nestedExpressions.push(initializer);
        this.appendOutput("{");
        if (this.formatInitializer) {
            this.appendOutput("\r\n");
            this.addParent(DUMMY_PARENT);
            this.appendIndentation();
        }
        int e = 0;
        while (e < initializer.getSlotCount()) {
            if (e > 0) {
                this.appendOutput(",");
                this.appendOutput(" ");
                if (this.formatInitializer) {
                    this.appendOutput("\r\n");
                }
            }
            if (this.formatInitializer) {
                this.appendIndentation();
            }
            this.appendOutput(initializer.getSlot(e));
            this.appendOutput(" ");
            this.appendOutput("=");
            this.appendOutput(" ");
            initializer.getExpression(e).accept(this);
            ++e;
        }
        if (this.formatInitializer) {
            this.removeLastParent();
            this.appendOutput("\r\n");
            this.appendIndentation();
        }
        this.appendOutput("}");
        this.nestedExpressions.pop();
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        boolean isConstraintType = ConstraintType.TYPE.isAssignableFrom(initializer.getContainedType());
        this.nestedExpressions.push(initializer);
        this.appendOutput("{");
        if (this.formatInitializer && initializer.getExpressionCount() > 0) {
            this.appendOutput("\r\n");
            this.addParent(DUMMY_PARENT);
            this.appendIndentation();
        }
        int i = 0;
        while (i < initializer.getExpressionCount()) {
            ConstraintSyntaxTree expr = initializer.getExpression(i);
            if (i > 0) {
                this.appendOutput(",");
                this.appendOutput(" ");
            }
            if (isConstraintType) {
                this.emitConstraintExpression(this.getExpressionContext(), expr);
            } else {
                expr.accept(this);
            }
            ++i;
        }
        if (this.formatInitializer && initializer.getExpressionCount() > 0) {
            this.removeLastParent();
            this.appendOutput("\r\n");
            this.appendIndentation();
        }
        this.appendOutput("}");
        this.nestedExpressions.pop();
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        if (this.handled.contains(attribute)) {
            this.handled.remove(attribute);
        } else {
            this.appendIndentation();
            this.appendOutput("annotate");
            this.appendOutput(" ");
            this.appendOutput(IvmlDatatypeVisitor.getUniqueType(attribute.getType()));
            this.appendOutput(" ");
            this.appendOutput(attribute.getName());
            this.appendOutput(" ");
            ConstraintSyntaxTree defltCst = attribute.getDefaultValue();
            if (defltCst != null) {
                this.appendOutput("=");
                this.appendOutput(" ");
                defltCst.accept(this);
                this.appendOutput(" ");
            }
            this.appendOutput("to");
            this.appendOutput(" ");
            if (attribute.isDot()) {
                this.appendOutput(".");
            } else {
                this.appendOutput(attribute.getElement().getName());
            }
            int a = 0;
            while (a < attribute.getSeriesCount()) {
                Attribute attr = attribute.getSeries(a);
                this.appendOutput(",");
                this.appendOutput(" ");
                this.appendOutput(attr.getElement().getName());
                this.handled.add(attr);
                ++a;
            }
            this.appendOutput(";");
            this.appendOutput("\r\n");
        }
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
        this.appendIndentation();
        this.appendOutput("freeze");
        this.appendOutput(" ");
        this.appendOutput("{");
        this.appendOutput("\r\n");
        this.addParent(freeze);
        int f = 0;
        while (f < freeze.getFreezableCount()) {
            IFreezable freezable = freeze.getFreezable(f);
            this.beforeNestedElement(freezable);
            this.appendIndentation();
            if (freezable instanceof CompoundAccessStatement) {
                freezable.accept(this);
            } else {
                if (freezable.getParent() instanceof Compound) {
                    this.appendOutput(freezable.getParent().getName());
                    this.appendOutput('.');
                }
                this.appendOutput(freezable.getName());
            }
            this.appendOutput(";");
            this.appendOutput("\r\n");
            ++f;
        }
        this.removeLastParent();
        this.appendIndentation();
        this.appendOutput("}");
        DecisionVariableDeclaration iter = freeze.getIter();
        ConstraintSyntaxTree selector = freeze.getSelector();
        if (iter != null && selector != null) {
            this.appendOutput(" ");
            this.appendOutput("but");
            this.appendOutput(" ");
            this.appendOutput("(");
            this.appendOutput(iter.getName());
            this.appendOutput("|");
            selector.accept(this);
            this.appendOutput(")");
        }
        this.appendOutput("\r\n");
    }

    @Override
    public void visitOperationDefinition(OperationDefinition opdef) {
        CustomOperation op = opdef.getOperation();
        int a = 0;
        while (a < op.getAnnotationCount()) {
            this.appendIndentation();
            this.appendOutput("@");
            this.appendOutput(op.getAnnotation(a));
            this.appendOutput("\r\n");
            ++a;
        }
        this.appendIndentation();
        this.appendOutput("def");
        this.appendOutput(" ");
        if (op.isStatic()) {
            this.appendOutput("static");
            this.appendOutput(" ");
        }
        this.appendOutput(IvmlDatatypeVisitor.getUniqueType(op.getReturns()));
        this.appendOutput(" ");
        this.appendOutput(opdef.getName());
        this.appendOutput("(");
        int paramSize = op.getParameterCount();
        int p = 0;
        while (p < paramSize) {
            if (p > 0) {
                this.appendOutput(",");
                this.appendOutput(" ");
            }
            this.emitDecisionVariableDeclarationExpression(op.getParameterDeclaration(p), null);
            ++p;
        }
        this.appendOutput(")");
        this.appendOutput(" ");
        this.appendOutput("=");
        this.appendOutput(" ");
        op.getFunction().accept(this);
        this.appendOutput(";");
        this.appendOutput("\r\n");
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        this.appendIndentation();
        this.appendOutput("eval");
        this.appendOutput(" ");
        this.appendOutput("{");
        this.appendOutput("\r\n");
        super.visitPartialEvaluationBlock(block);
        this.appendIndentation();
        this.appendOutput("}");
        this.appendOutput(";");
        this.appendOutput("\r\n");
    }

    @Override
    public void visitProjectInterface(ProjectInterface iface) {
        this.appendIndentation();
        this.appendOutput("interface");
        this.appendOutput(" ");
        this.appendOutput(iface.getName());
        this.appendOutput(" ");
        this.appendOutput("{");
        this.appendOutput("\r\n");
        this.addParent(iface);
        int e = 0;
        while (e < iface.getExportsCount()) {
            DecisionVariableDeclaration export = iface.getExport(e);
            this.appendIndentation();
            this.appendOutput("export");
            this.appendOutput(" ");
            if (this.needsQualification(export)) {
                this.appendOutput(export.getQualifiedName());
            } else {
                this.appendOutput(export.getName());
            }
            this.appendOutput(";");
            this.appendOutput("\r\n");
            ++e;
        }
        this.removeLastParent();
        this.appendIndentation();
        this.appendOutput("}");
        this.appendOutput("\r\n");
    }

    @Override
    public void visitDerivedDatatype(DerivedDatatype datatype) {
        this.appendIndentation();
        this.appendOutput("typedef");
        this.appendOutput(" ");
        this.appendOutput(datatype.getName());
        this.appendOutput(" ");
        this.appendOutput(IvmlDatatypeVisitor.getUniqueType(datatype.getBasisType()));
        int cCount = datatype.getConstraintCount();
        if (cCount != 0) {
            this.appendOutput(" ");
            this.appendOutput("with");
            this.appendOutput(" ");
            this.appendOutput("(");
            int c = 0;
            while (c < cCount) {
                ConstraintSyntaxTree cst;
                if (c > 0) {
                    this.appendOutput(",");
                    this.appendOutput(" ");
                }
                if ((cst = datatype.getConstraint(c).getConsSyntax()) != null) {
                    cst.accept(this);
                }
                ++c;
            }
            this.appendOutput(")");
        }
        this.appendOutput(";");
        this.appendOutput("\r\n");
    }

    @Override
    public void visitEnumLiteral(EnumLiteral literal) {
        this.appendOutput(literal.getName());
    }

    @Override
    public void visitReference(Reference reference) {
    }

    @Override
    public void visitSequence(Sequence sequence) {
        this.appendIndentation();
        this.appendOutput("sequenceOf");
        this.appendOutput("(");
        this.appendOutput(sequence.getContainedType().getName());
        this.appendOutput(")");
        this.appendOutput(" ");
        this.appendOutput(sequence.getName());
        this.appendOutput(";");
        this.appendOutput("\r\n");
    }

    @Override
    public void visitSet(Set set) {
        this.appendIndentation();
        this.appendOutput("setOf");
        this.appendOutput("(");
        this.appendOutput(set.getContainedType().getName());
        this.appendOutput(")");
        this.appendOutput(" ");
        this.appendOutput(set.getName());
        this.appendOutput(";");
        this.appendOutput("\r\n");
    }

    @Override
    public void visitReferenceValue(ReferenceValue referenceValue) {
        this.appendOutput("refBy");
        this.appendOutput("(");
        AbstractVariable referenced = referenceValue.getValue();
        if (referenced != null) {
            Object containerPrefix = "";
            Object containerPostfix = "";
            IModelElement iter = referenced.getParent();
            while (iter instanceof DecisionVariableDeclaration && Container.TYPE.isAssignableFrom(((DecisionVariableDeclaration)iter).getType())) {
                containerPrefix = iter.getName() + "[" + (String)containerPrefix;
                containerPostfix = (String)containerPostfix + "]";
                iter = iter.getParent();
            }
            this.appendOutput((String)containerPrefix + referenced.getName() + (String)containerPostfix);
        } else {
            ConstraintSyntaxTree ex = referenceValue.getValueEx();
            if (ex != null) {
                ex.accept(this);
            }
        }
        this.appendOutput(")");
    }

    private boolean needsQualification(AbstractVariable var) {
        boolean found = false;
        String name = var.getName();
        int p = this.getParentCount() - 1;
        while (!found && p > 0) {
            found = this.needsQualificationThroughContext(this.getParent(p), name, var, true);
            --p;
        }
        if (!found) {
            int n = this.nestedValues.size() - 1;
            while (!found && n >= 0) {
                found = this.needsQualificationThroughContext(((Value)this.nestedValues.get(n)).getType(), name, var, false);
                --n;
            }
            if (found) {
                found = false;
            } else {
                Project underVisiting = this.getParent(Project.class);
                if (var.getTopLevelParent() != underVisiting) {
                    found = this.variableUsage.needsQualification(var);
                }
            }
        }
        return found;
    }

    private boolean needsQualificationThroughContext(Object context, String name, AbstractVariable var, boolean exclude) {
        boolean found = false;
        if (context instanceof IDecisionVariableContainer) {
            IDecisionVariableContainer cont = (IDecisionVariableContainer)context;
            DecisionVariableDeclaration elt = cont.getElement(name);
            boolean bl = found = elt != null && elt.getName().equals(name);
            if (exclude) {
                found &= var != elt;
            }
        }
        return found;
    }

    @Override
    public void visitVariable(Variable variable) {
        AbstractVariable var = variable.getVariable();
        boolean needsFqn = false;
        if (variable.getQualifier() != null) {
            variable.getQualifier().accept(this);
            this.appendOutput(".");
        } else {
            needsFqn = this.needsQualification(variable.getVariable());
        }
        if (needsFqn) {
            this.appendOutput(var.getQualifiedName());
        } else {
            this.appendOutput(var.getName());
        }
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable(variable);
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        this.appendOutput("(");
        parenthesis.getExpr().accept(this);
        this.appendOutput(")");
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        this.callStack.push(call);
        Operation resolved = call.getResolvedOperation();
        Operation.FormattingHint hint = resolved != null ? resolved.getFormattingHint() : Operation.FormattingHint.FUNCTION_CALL;
        this.appendOCLFeatureCall(call, hint);
        this.callStack.pop();
    }

    protected void appendOCLFeatureCall(OCLFeatureCall call, Operation.FormattingHint hint) {
        String name = call.getOperation();
        switch (hint) {
            case FUNCTION_CALL: {
                if ("[]".equals(name) && 1 == call.getParameterCount()) {
                    call.getOperand().accept(this);
                    this.appendOutput("[");
                    call.getParameter(0).accept(this);
                    this.appendOutput("]");
                    break;
                }
                this.appendOutput(name);
                this.appendOutput("(");
                ConstraintSyntaxTree operand = call.getOperand();
                if (operand != null) {
                    operand.accept(this);
                }
                if (call.getParameterCount() > 0) {
                    int p = 0;
                    while (p < call.getParameterCount()) {
                        ConstraintSyntaxTree param = call.getParameter(p);
                        if (operand != null || operand == null && p > 0) {
                            this.appendOutput(",");
                        }
                        if (param.getName() != null) {
                            this.appendOutput(" ");
                            this.appendOutput(param.getName());
                            this.appendOutput(" ");
                            this.appendOutput("=");
                        }
                        this.appendOutput(" ");
                        param.accept(this);
                        ++p;
                    }
                }
                this.appendOutput(")");
                break;
            }
            case OPERATOR_INFIX: {
                call.getOperand().accept(this);
                int p = 0;
                while (p < call.getParameterCount()) {
                    this.appendOutput(" ");
                    this.appendOutput(name);
                    this.appendOutput(" ");
                    call.getParameter(p).accept(this);
                    ++p;
                }
                break;
            }
            case OPERATOR_PREFIX: {
                this.appendOutput(name);
                this.appendOutput(" ");
                call.getOperand().accept(this);
                break;
            }
            case OPERATOR_POSTFIX: {
                call.getOperand().accept(this);
                this.appendOutput(name);
                break;
            }
        }
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        int e = 0;
        while (e < expression.getExpressionCount()) {
            OCLFeatureCall call = expression.getExpression(e);
            if (e == 0) {
                call.getOperand().accept(this);
                this.appendOutput(" ");
            }
            int p = 0;
            while (p < call.getParameterCount()) {
                this.appendOutput(call.getOperation());
                this.appendOutput(" ");
                call.getParameter(p).accept(this);
                if (e + 1 != expression.getExpressionCount() || p + 1 != call.getParameterCount()) {
                    this.appendOutput(" ");
                }
                ++p;
            }
            ++e;
        }
    }

    @Override
    public void visitConstraint(Constraint constraint) {
        this.appendIndentation();
        super.visitConstraint(constraint);
        this.appendOutput(";");
        this.appendOutput("\r\n");
    }

    @Override
    public void visitLet(Let let) {
        this.appendOutput("let");
        this.appendOutput(" ");
        this.emitDecisionVariableDeclarationExpression(let.getVariable(), let.getInitExpression());
        this.appendOutput(" ");
        this.appendOutput("in");
        this.appendOutput(" ");
        let.getInExpression().accept(this);
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        this.appendOutput("if");
        this.appendOutput(" ");
        ifThen.getIfExpr().accept(this);
        this.appendOutput(" ");
        this.appendOutput("then");
        this.appendOutput(" ");
        ifThen.getThenExpr().accept(this);
        this.appendOutput(" ");
        this.appendOutput("else");
        this.appendOutput(" ");
        ifThen.getElseExpr().accept(this);
        this.appendOutput(" ");
        this.appendOutput("endif");
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        call.getContainer().accept(this);
        this.appendOutput("->");
        this.appendOutput(call.getOperation());
        this.appendOutput("(");
        int declCount = call.getDeclaratorsCount();
        if (1 != declCount || !call.getDeclarator(0).isTemporaryDeclarator()) {
            int d = 0;
            while (d < declCount) {
                IDatatype nextType;
                ConstraintSyntaxTree next;
                DecisionVariableDeclaration decl = call.getDeclarator(d);
                ConstraintSyntaxTree deflt = decl.getDefaultValue();
                IDatatype type = decl.getType();
                if (d + 1 >= declCount) {
                    next = null;
                    nextType = null;
                } else {
                    DecisionVariableDeclaration nextDecl = call.getDeclarator(d + 1);
                    next = nextDecl.getDefaultValue();
                    nextType = nextDecl.getType();
                }
                if (decl.isDeclaratorTypeExplicit()) {
                    this.appendOutput(IvmlDatatypeVisitor.getUniqueType(decl.getType()));
                    this.appendOutput(" ");
                }
                this.appendOutput(decl.getName());
                if (deflt != null && deflt != next) {
                    this.appendOutput(" ");
                    this.appendOutput("=");
                    this.appendOutput(" ");
                    decl.getDefaultValue().accept(this);
                }
                if (d < declCount - 1) {
                    if (deflt == null && next != null || nextType != null && type != nextType) {
                        this.appendOutput(";");
                    } else {
                        this.appendOutput(",");
                    }
                }
                ++d;
            }
            this.appendOutput("|");
            call.getExpression().accept(this);
        } else if (call.getExpression() instanceof CompoundAccess) {
            CompoundAccess ca = (CompoundAccess)call.getExpression();
            this.appendOutput(ca.getSlotName());
        }
        this.appendOutput(")");
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        access.getCompoundExpression().accept(this);
        this.appendOutput('.');
        this.appendOutput(access.getSlotName());
    }

    @Override
    public void visitMetaTypeValue(MetaTypeValue value) {
        this.appendOutput(IvmlDatatypeVisitor.getUniqueType(value.getValue()));
    }

    @Override
    public void visitNullValue(NullValue value) {
        this.appendOutput("null");
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
        this.dupLastComment();
        this.appendIndentation();
        this.appendOutput("assign");
        this.appendOutput(" ");
        this.appendOutput("(");
        int d = 0;
        while (d < assignment.getAssignmentDataCount()) {
            if (d > 0) {
                this.appendOutput(",");
                this.appendOutput(" ");
            }
            AttributeAssignment.Assignment data = assignment.getAssignmentData(d);
            this.appendOutput(data.getName());
            this.appendOutput(" ");
            this.appendOutput(data.getOperation());
            this.appendOutput(" ");
            data.getExpression().accept(this);
            ++d;
        }
        this.appendOutput(")");
        this.appendOutput(" ");
        this.appendOutput("to");
        this.appendOutput(" ");
        this.appendOutput("{");
        this.appendOutput("\r\n");
        super.visitAttributeAssignment(assignment);
        this.appendIndentation();
        this.appendOutput("}");
        this.appendOutput("\r\n");
        this.popLastComment();
    }

    @Override
    public void visitComment(Comment comment) {
        if (this.emitComments) {
            String text = comment.getName();
            if (text != null) {
                this.appendOutput(text);
            }
            this.setLastComment(comment);
        }
    }

    @Override
    public void visitComment(net.ssehub.easy.varModel.cst.Comment comment) {
        String text = comment.getComment();
        if (text != null) {
            this.appendOutput(text);
        }
        comment.getExpr().accept(this);
    }

    @Override
    protected void beforeNestedElement(Object element) {
        String name;
        Comment nestedComment;
        Comment lastComment = this.getLastComment();
        if (lastComment != null && (nestedComment = lastComment.getComment(element)) != null && (name = nestedComment.getName()) != null) {
            this.appendOutput(name);
        }
    }

    @Override
    public void visitCompound(Compound compound) {
        this.dupLastComment();
        super.visitCompound(compound);
        this.popLastComment();
    }

    private Comment getLastComment() {
        Comment result = null;
        if (this.emitComments && !this.lastComment.isEmpty()) {
            result = this.lastComment.peek();
        }
        return result;
    }

    private void dupLastComment() {
        if (this.emitComments && !this.lastComment.isEmpty()) {
            this.lastComment.push(this.lastComment.peek());
        }
    }

    private Comment popLastComment() {
        Comment result = null;
        if (this.emitComments && !this.lastComment.isEmpty()) {
            result = this.lastComment.pop();
        }
        return result;
    }

    private void setLastComment(Comment comment) {
        if (this.emitComments) {
            if (!this.lastComment.isEmpty()) {
                this.lastComment.pop();
            }
            this.lastComment.push(comment);
        }
    }

    @Override
    public void visitCompoundAccessStatement(CompoundAccessStatement access) {
        AbstractVariable var = access.getCompoundVariable();
        if (this.needsQualification(var)) {
            this.appendOutput(var.getQualifiedName());
        } else {
            this.appendOutput(var.getName());
        }
        this.appendOutput('.');
        this.appendOutput(access.getSlotName());
    }

    @Override
    public void visitVersionValue(VersionValue value) {
        Object tmp = Version.toString((Version)value.getValue());
        if (((String)tmp).length() > 0) {
            tmp = "v" + (String)tmp;
        }
        this.appendOutput((String)tmp);
    }

    @Override
    public void visitSelf(Self self) {
        this.appendOutput("self");
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        this.appendOutput("{");
        this.appendOutput("\r\n");
        this.increaseAdditionalIndentation();
        int e = 0;
        int n = block.getExpressionCount();
        while (e < n) {
            this.appendIndentation();
            block.getExpression(e).accept(this);
            this.appendOutput(";");
            this.appendOutput("\r\n");
            ++e;
        }
        this.decreaseAdditionalIndentation();
        this.appendIndentation();
        this.appendOutput("}");
    }
}

