/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.varModel.confModel.ConfigQuery;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;

public class QueryCache {
    private Configuration config;
    private Map<IDatatype, List<ConstraintSyntaxTree>> refValues;

    protected QueryCache() {
    }

    QueryCache(Configuration config) {
        this.config = config;
        this.refValues = new HashMap<IDatatype, List<ConstraintSyntaxTree>>();
    }

    void clear() {
        this.refValues.clear();
    }

    public List<ConstraintSyntaxTree> getPossibleValues(Reference refType) {
        List<ConstraintSyntaxTree> possibleValues = this.refValues.get(refType.getType());
        if (possibleValues == null) {
            List<ConstraintSyntaxTree> values = ConfigQuery.possibleValuesForReferences(this.config, refType);
            possibleValues = Collections.unmodifiableList(values);
            this.refValues.put(refType.getType(), possibleValues);
        }
        return possibleValues;
    }
}

