/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.Locale;
import net.ssehub.easy.basics.DefaultLocale;
import net.ssehub.easy.varModel.confModel.AllFreezeSelector;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cstEvaluation.ConstantAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationContext;
import net.ssehub.easy.varModel.cstEvaluation.EvaluatorRegistry;
import net.ssehub.easy.varModel.cstEvaluation.IOperationEvaluator;
import net.ssehub.easy.varModel.cstEvaluation.IntegerOperations;
import net.ssehub.easy.varModel.cstEvaluation.RealOperations;
import net.ssehub.easy.varModel.cstEvaluation.VariableAccessor;
import net.ssehub.easy.varModel.cstEvaluation.VariableValueCopier;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.datatypes.StringType;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class GenericOperations {
    static final IOperationEvaluator ASSIGNMENT = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return GenericOperations.assign(operand, arguments, true);
        }
    };
    static final IOperationEvaluator EQUALS = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return GenericOperations.equals(operand, arguments, false);
        }
    };
    static final IOperationEvaluator UNEQUALS = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return GenericOperations.equals(operand, arguments, true);
        }
    };
    static final IOperationEvaluator TO_STRING = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (operand != null) {
                try {
                    Value sv = operand.getValue();
                    String sValue = sv instanceof StringValue ? ((StringValue)sv).getValue() : StringProvider.toIvmlString(operand.getValue());
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(ValueFactory.createValue(StringType.TYPE, sValue), true, operand.getContext());
                }
                catch (ValueDoesNotMatchTypeException valueDoesNotMatchTypeException) {
                    // empty catch block
                }
            }
            return result;
        }
    };
    static final IOperationEvaluator IS_DEFINED = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return GenericOperations.checkDefined(operand, arguments, false);
        }
    };
    static final IOperationEvaluator IF_DEFINED = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            return GenericOperations.checkDefined(operand, arguments, true);
        }
    };
    static final IOperationEvaluator COPY = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            VariableAccessor result = null;
            if (operand != null && 1 == arguments.length) {
                Value namePrefixValue = arguments[0].getValue();
                String namePrefix = namePrefixValue instanceof StringValue ? ((StringValue)namePrefixValue).getValue() : null;
                try {
                    IDecisionVariable local = VariableValueCopier.copy(operand.getVariable(), namePrefix);
                    result = ((VariableAccessor)VariableAccessor.POOL.getInstance()).bind(local, operand.getContext(), true);
                }
                catch (ConfigurationException configurationException) {
                }
                catch (ValueDoesNotMatchTypeException valueDoesNotMatchTypeException) {
                }
                catch (CSTSemanticException cSTSemanticException) {
                    // empty catch block
                }
            }
            return result;
        }
    };
    static final IOperationEvaluator TYPE_OF = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            Value oVal = operand.getValue();
            if (oVal != null) {
                try {
                    Value resVal = ValueFactory.createValue(MetaType.TYPE, oVal.getType());
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(resVal, true, operand.getContext());
                }
                catch (ValueDoesNotMatchTypeException valueDoesNotMatchTypeException) {
                    // empty catch block
                }
            }
            return result;
        }
    };
    static final IOperationEvaluator IS_TYPE_OF = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (1 == arguments.length) {
                IDatatype oType = GenericOperations.toType(operand.getValue());
                IDatatype aType = GenericOperations.toType(arguments[0].getValue());
                if (oType != null && aType != null) {
                    BooleanValue res = BooleanValue.toBooleanValue(TypeQueries.sameTypes(oType, aType));
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(res, true, operand.getContext());
                }
            }
            return result;
        }
    };
    static final IOperationEvaluator IS_KIND_OF = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (1 == arguments.length) {
                IDatatype oType = GenericOperations.toType(operand.getValue());
                IDatatype aType = GenericOperations.toType(arguments[0].getValue());
                if (oType != null && aType != null) {
                    BooleanValue res = BooleanValue.toBooleanValue(oType.isAssignableFrom(aType));
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(res, true, operand.getContext());
                }
            }
            return result;
        }
    };
    static final IOperationEvaluator AS_TYPE = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            EvaluationAccessor result = null;
            if (1 == arguments.length) {
                Value oValue = operand.getValue();
                IDatatype oType = GenericOperations.toType(oValue);
                IDatatype aType = GenericOperations.toType(arguments[0].getValue());
                if (aType.isAssignableFrom(oType)) {
                    result = operand.getVariable() != null ? ((VariableAccessor)VariableAccessor.POOL.getInstance()).bind(operand.getVariable(), operand.getContext()) : ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(oValue, false, operand.getContext());
                }
            }
            return result;
        }
    };
    static final IOperationEvaluator GET_LOCALE = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            try {
                result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(ValueFactory.createValue(StringType.TYPE, GenericOperations.localeToString(operand)), true, operand.getContext());
            }
            catch (ValueDoesNotMatchTypeException valueDoesNotMatchTypeException) {
                // empty catch block
            }
            return result;
        }
    };
    static final IOperationEvaluator SET_LOCALE = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            Value arg;
            ConstantAccessor result = null;
            if (1 == arguments.length && (arg = arguments[0].getValue()) instanceof StringValue) {
                String loc = ((StringValue)arg).getValue();
                operand.getContext().setLocale(DefaultLocale.toLocale((String)loc));
                try {
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(ValueFactory.createValue(StringType.TYPE, GenericOperations.localeToString(operand)), true, operand.getContext());
                }
                catch (ValueDoesNotMatchTypeException valueDoesNotMatchTypeException) {
                    // empty catch block
                }
            }
            return result;
        }
    };

    private GenericOperations() {
    }

    public static String localeToString(EvaluationAccessor accessor) {
        return DefaultLocale.toString((Locale)accessor.getContext().getLocale());
    }

    public static void register() {
        EvaluatorRegistry.registerEvaluator(IS_TYPE_OF, AnyType.IS_TYPE_OF);
        EvaluatorRegistry.registerEvaluator(IS_KIND_OF, AnyType.IS_KIND_OF);
        EvaluatorRegistry.registerEvaluator(GET_LOCALE, AnyType.GET_LOCALE);
        EvaluatorRegistry.registerEvaluator(SET_LOCALE, AnyType.SET_LOCALE);
        EvaluatorRegistry.registerEvaluator(AS_TYPE, AnyType.AS_TYPE);
        EvaluatorRegistry.registerEvaluator(ASSIGNMENT, AnyType.ASSIGNMENT);
        EvaluatorRegistry.registerEvaluator(EQUALS, AnyType.EQUALS);
        EvaluatorRegistry.registerEvaluator(UNEQUALS, AnyType.NOTEQUALS);
        EvaluatorRegistry.registerEvaluator(UNEQUALS, AnyType.NOTEQUALS_ALIAS);
    }

    static EvaluationAccessor equals(EvaluationAccessor operand, EvaluationAccessor[] arguments, boolean negate) {
        EvaluationAccessor result;
        if (operand != null && arguments != null && arguments.length == 1) {
            Value oValue = operand.getValue();
            Value aValue = arguments[0].getValue();
            if (oValue != null && oValue.getType() == RealType.TYPE && aValue != null && aValue.getType() == IntegerType.TYPE) {
                result = RealOperations.equalsRealInt(operand, arguments, negate);
            } else if (oValue != null && oValue.getType() == IntegerType.TYPE && aValue != null && aValue.getType() == RealType.TYPE) {
                result = IntegerOperations.equalsIntReal(operand, arguments, negate);
            } else {
                if (!negate && operand.getContext().allowPropagation()) {
                    if ((oValue == null || !operand.isAssigned()) && operand.isAssignable() || GenericOperations.isAssignableCompound(operand)) {
                        GenericOperations.assign(operand, arguments, false);
                        oValue = operand.getValue();
                    } else if (aValue == null && arguments[0].isAssignable()) {
                        EvaluationAccessor[] temp = new EvaluationAccessor[]{operand};
                        GenericOperations.assign(arguments[0], temp, false);
                        aValue = operand.getValue();
                    }
                }
                if (oValue == null || aValue == null) {
                    result = null;
                } else {
                    boolean equals;
                    boolean operandIsRef = oValue instanceof ReferenceValue;
                    boolean parameterIsRef = aValue instanceof ReferenceValue;
                    if (oValue == null || aValue == null) {
                        equals = false;
                    } else if (operandIsRef != parameterIsRef) {
                        oValue = operand.getDereferencedValue();
                        aValue = arguments[0].getDereferencedValue();
                        equals = oValue.equals(aValue);
                    } else {
                        equals = oValue.equals(aValue);
                    }
                    if (negate) {
                        equals = !equals;
                    }
                    BooleanValue resValue = BooleanValue.toBooleanValue(equals);
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(resValue, true, operand.getContext());
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    static final EvaluationAccessor equalsNull(Value operand, Value argument, EvaluationContext context, boolean negate) {
        ConstantAccessor result;
        Boolean equals = operand instanceof NullValue ? (argument instanceof NullValue ? Boolean.valueOf(true) : Boolean.valueOf(false)) : (operand != null && argument instanceof NullValue ? Boolean.valueOf(false) : null);
        if (equals != null) {
            if (negate) {
                equals = equals == false;
            }
            result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(BooleanValue.toBooleanValue(equals), true, context);
        } else {
            result = null;
        }
        return result;
    }

    private static IDatatype toType(Value value) {
        IDatatype result = value instanceof MetaTypeValue ? ((MetaTypeValue)value).getValue() : (value != null ? value.getType() : null);
        return result;
    }

    private static boolean isAssignableCompound(EvaluationAccessor operand) {
        boolean result = false;
        if (operand.getValue() instanceof CompoundValue) {
            result = true;
            IDecisionVariable oCmp = operand.getVariable();
            if (oCmp != null) {
                int i = 0;
                while (i < oCmp.getNestedElementsCount()) {
                    if (oCmp.getNestedElement(i).getState() != AssignmentState.UNDEFINED) {
                        result = false;
                    }
                    ++i;
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    private static EvaluationAccessor assign(EvaluationAccessor operand, EvaluationAccessor[] arguments, boolean asAssignment) {
        ConstantAccessor result = null;
        if (arguments.length == 1 && operand != null && operand.setValue(arguments[0].getValue(), asAssignment)) {
            IDecisionVariable var = operand.getVariable();
            if (var != null && var.getDeclaration().isConstant()) {
                var.freeze(AllFreezeSelector.INSTANCE);
            }
            result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(BooleanValue.TRUE, true, operand.getContext());
        }
        return result;
    }

    private static final EvaluationAccessor checkDefined(EvaluationAccessor operand, EvaluationAccessor[] arguments, boolean lazy) {
        EvaluationContext context;
        boolean eval;
        boolean undefined = false;
        if (operand == null) {
            eval = false;
            context = null;
        } else {
            IDecisionVariable var = operand.getVariable();
            if (lazy && var != null && (var.getValue() == null || var.getState() == AssignmentState.UNDEFINED)) {
                eval = false;
                context = null;
                undefined = true;
            } else if (var != null && var.enableWasAssignedForIsDefined()) {
                eval = operand.getVariable().wasAssigned();
                context = operand.getContext();
            } else {
                Value val = operand.getValue();
                eval = val != null && NullValue.INSTANCE != val;
                context = operand.getContext();
            }
        }
        ConstantAccessor result = undefined ? null : ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(BooleanValue.toBooleanValue(eval), true, context);
        return result;
    }
}

