/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public class DecisionVariableDeclaration
extends AbstractVariable
implements IFreezable,
IAttributableElement,
IVariable {
    private List<Attribute> attributes;

    DecisionVariableDeclaration() {
        super(null, null, null, null);
    }

    public DecisionVariableDeclaration(String name, IDatatype type, IModelElement parent) {
        super(name, type, null, parent);
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visitDecisionVariableDeclaration(this);
    }

    private boolean addAttribute(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
        }
        boolean found = false;
        int a = 0;
        while (!found && a < this.attributes.size()) {
            found = this.attributes.get(a).getName().equals(attribute.getName());
            ++a;
        }
        if (!found) {
            this.attributes.add(attribute);
        }
        return !found;
    }

    @Override
    public boolean attribute(Attribute attribute) {
        return this.addAttribute(attribute);
    }

    @Override
    public int getAttributesCount() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    @Override
    public Attribute getAttribute(int index) {
        if (this.attributes == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes.get(index);
    }

    @Override
    public Attribute getAttribute(String name) {
        Attribute result = null;
        if (this.attributes != null) {
            int a = 0;
            while (result == null && a < this.attributes.size()) {
                Attribute attr = this.attributes.get(a);
                if (attr.getName().equals(name)) {
                    result = attr;
                }
                ++a;
            }
        }
        return result;
    }

    @Override
    public boolean isTemporaryVariable() {
        return this.getParent() instanceof Constraint;
    }

    public boolean isTemporaryDeclarator() {
        boolean result = false;
        if (this.getParent() instanceof Constraint) {
            Constraint c = (Constraint)this.getParent();
            result = c.getConsSyntax() == null;
        }
        return result;
    }

    @Override
    public boolean isAttribute() {
        return false;
    }

    @Override
    public boolean propagateAttribute(Attribute attribute) {
        Attribute att = new Attribute(attribute.getName(), attribute.getType(), this.getParent(), this, attribute);
        ConstraintSyntaxTree deflt = attribute.getDefaultValue();
        if (deflt != null) {
            try {
                att.setValue(deflt);
            }
            catch (ValueDoesNotMatchTypeException e) {
                DecisionVariableDeclaration.logger().exception((Exception)e);
            }
            catch (CSTSemanticException e) {
                DecisionVariableDeclaration.logger().exception((Exception)e);
            }
        }
        return this.addAttribute(att);
    }

    private static EASyLoggerFactory.EASyLogger logger() {
        return EASyLoggerFactory.INSTANCE.getLogger(DecisionVariableDeclaration.class, "net.ssehub.easy.varModel");
    }

    public boolean isDeclaratorTypeExplicit() {
        return false;
    }

    @Override
    public boolean isConstant() {
        return false;
    }
}

