/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.StringType;
import net.ssehub.easy.varModel.model.datatypes.VersionType;

public class BaseTypeVisitor
implements IDatatypeVisitor {
    private static final List<BaseTypeVisitor> POOL = new ArrayList<BaseTypeVisitor>();
    private IDatatype type;

    private BaseTypeVisitor() {
    }

    private void setType(IDatatype type) {
        this.type = type;
    }

    private IDatatype getType() {
        return this.type;
    }

    private static final synchronized BaseTypeVisitor getInstance(IDatatype type) {
        BaseTypeVisitor result = POOL.size() > 0 ? POOL.remove(0) : new BaseTypeVisitor();
        result.setType(type);
        return result;
    }

    private static final synchronized void releaseInstance(BaseTypeVisitor visitor) {
        visitor.setType(null);
        POOL.add(visitor);
    }

    public static final synchronized IDatatype getBaseType(IDatatype type) {
        BaseTypeVisitor visitor = BaseTypeVisitor.getInstance(type);
        type.accept(visitor);
        IDatatype result = visitor.getType();
        BaseTypeVisitor.releaseInstance(visitor);
        return result;
    }

    @Override
    public void visitDatatype(IDatatype datatype) {
        this.type = datatype;
    }

    @Override
    public void visitAnyType(AnyType datatype) {
        this.type = datatype;
    }

    @Override
    public void visitMetaType(MetaType datatype) {
        this.type = datatype;
    }

    @Override
    public void visitDerivedType(DerivedDatatype datatype) {
        datatype.getBasisType().accept(this);
    }

    @Override
    public void visitSet(Set set) {
        this.type = set;
    }

    @Override
    public void visitSequence(Sequence sequence) {
        this.type = sequence;
    }

    @Override
    public void visitReference(Reference reference) {
        this.type = reference;
    }

    @Override
    public void visitBooleanType(BooleanType type) {
        this.type = type;
    }

    @Override
    public void visitStringType(StringType type) {
        this.type = type;
    }

    @Override
    public void visitConstraintType(ConstraintType type) {
        this.type = type;
    }

    @Override
    public void visitIntegerType(IntegerType type) {
        this.type = type;
    }

    @Override
    public void visitRealType(RealType type) {
        this.type = type;
    }

    @Override
    public void visitCompoundType(Compound compound) {
        this.type = compound;
    }

    @Override
    public void visitEnumType(Enum enumType) {
        this.type = enumType;
    }

    @Override
    public void visitOrderedEnumType(OrderedEnum enumType) {
        this.type = enumType;
    }

    @Override
    public void visitVersionType(VersionType type) {
        this.type = type;
    }
}

