/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.persistency;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.persistency.IVMLWriter;

public class ConfigurableIVMLWriter
extends IVMLWriter {
    private List<Project> imports;
    private int projectNestingLevel = 0;

    public ConfigurableIVMLWriter(Writer writer, boolean emitComments, boolean emitImports) {
        super(writer, emitComments);
        if (emitImports) {
            this.imports = new ArrayList<Project>();
        }
    }

    @Override
    public void visitProjectImport(ProjectImport pImport) {
        super.visitProjectImport(pImport);
        Project resolved = (Project)pImport.getResolved();
        if (this.imports != null && resolved != null && !this.imports.contains(resolved)) {
            this.imports.add(resolved);
        }
    }

    @Override
    public void visitProject(Project project) {
        ++this.projectNestingLevel;
        super.visitProject(project);
        --this.projectNestingLevel;
        if (this.projectNestingLevel == 0 && this.imports != null) {
            ++this.projectNestingLevel;
            int i = 0;
            while (i < this.imports.size()) {
                this.imports.get(i).accept(this);
                ++i;
            }
            --this.projectNestingLevel;
        }
    }
}

