/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.persistency;

import java.io.StringWriter;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.persistency.IVMLWriter;

public class ConstraintSplitWriter
extends IVMLWriter {
    private StringWriter before = new StringWriter();
    private StringWriter constraint = new StringWriter();
    private StringWriter after = new StringWriter();
    private IConstraintFilter filter;

    public ConstraintSplitWriter(IConstraintFilter filter) {
        super(new StringWriter());
        this.filter = filter;
        this.before = new StringWriter();
        this.setWriter(this.before);
    }

    private boolean pre(IModelElement context, ConstraintSyntaxTree constraint) {
        boolean split = false;
        if (this.filter != null) {
            split = this.filter.splitAt(context, constraint);
        }
        if (split) {
            this.filter = null;
            this.setWriter(this.constraint);
        }
        return split;
    }

    private void post(boolean split) {
        if (split) {
            this.setWriter(this.after);
        }
    }

    @Override
    protected void emitConstraintExpression(IModelElement context, ConstraintSyntaxTree constraint) {
        boolean split = this.pre(context, constraint);
        super.emitConstraintExpression(context, constraint);
        this.post(split);
    }

    @Override
    protected void emitDecisionVariableDeclarationDefault(DecisionVariableDeclaration decl, ConstraintSyntaxTree defaultValue) {
        if (this.filter != null && ConstraintType.TYPE.isAssignableFrom(decl.getType())) {
            boolean split = this.pre(decl.getParent(), defaultValue);
            super.emitDecisionVariableDeclarationDefault(decl, defaultValue);
            this.post(split);
        } else {
            super.emitDecisionVariableDeclarationDefault(decl, defaultValue);
        }
    }

    public String getBeforeText() {
        return this.before.toString();
    }

    public String getConstraintText() {
        return this.constraint.toString();
    }

    public String getAfterText() {
        return this.after.toString();
    }

    public String[] getSplit(boolean trimConstraint, boolean trimParenthesis) {
        String[] result = new String[3];
        String addBefore = "";
        result[0] = this.getBeforeText();
        result[1] = this.getConstraintText();
        result[2] = this.getAfterText();
        if (trimConstraint) {
            String cTmp = result[1];
            int leftPos = 0;
            while (leftPos < cTmp.length() && ConstraintSplitWriter.doTrim(cTmp.charAt(leftPos))) {
                ++leftPos;
            }
            int rightPos = cTmp.length();
            while (rightPos > leftPos && ConstraintSplitWriter.doTrim(cTmp.charAt(rightPos - 1))) {
                --rightPos;
            }
            if (trimParenthesis) {
                int leftParenPos = leftPos;
                int rightParenPos = rightPos;
                if (leftParenPos < cTmp.length() && '(' == cTmp.charAt(leftParenPos)) {
                    ++leftParenPos;
                }
                if (leftParenPos != leftPos && rightParenPos > 0 && ')' == cTmp.charAt(rightParenPos - 1)) {
                    --rightParenPos;
                }
                if (leftParenPos != leftPos && rightParenPos != rightPos) {
                    leftPos = leftParenPos;
                    rightPos = rightParenPos;
                    addBefore = "\n";
                }
            }
            if (leftPos > 0) {
                result[0] = String.valueOf(result[0]) + cTmp.substring(0, leftPos) + addBefore;
                result[1] = cTmp.substring(leftPos);
                cTmp = result[1];
                rightPos -= leftPos;
            }
            if (rightPos < cTmp.length()) {
                result[2] = cTmp.substring(rightPos) + result[2];
                result[1] = cTmp.substring(0, rightPos);
            }
        }
        return result;
    }

    private static boolean doTrim(char ch) {
        return Character.isWhitespace(ch) || '\r' == ch;
    }

    public static interface IConstraintFilter {
        public boolean splitAt(IModelElement var1, ConstraintSyntaxTree var2);
    }

    public static class IdentityConstraintFilter
    implements IConstraintFilter {
        private ConstraintSyntaxTree constraint;

        public IdentityConstraintFilter(ConstraintSyntaxTree constraint) {
            this.constraint = constraint;
        }

        @Override
        public boolean splitAt(IModelElement context, ConstraintSyntaxTree constraint) {
            return this.constraint == constraint;
        }
    }
}

