/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cst;

import java.util.Map;
import net.ssehub.easy.basics.modelManagement.IVariable;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BasicCopyVisitor;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;

public class CopyVisitor
extends BasicCopyVisitor {
    private Map<AbstractVariable, AbstractVariable> mapping;
    private IVersionRestriction.IVariableMapper mapper;
    private IVariableReplacer replacer;

    public CopyVisitor() {
        this((Map<AbstractVariable, AbstractVariable>)null);
    }

    public CopyVisitor(Map<AbstractVariable, AbstractVariable> mapping) {
        this.mapping = mapping;
    }

    public CopyVisitor(IVersionRestriction.IVariableMapper mapper) {
        this.mapper = mapper;
        if (mapper instanceof IVariableReplacer) {
            this.replacer = (IVariableReplacer)mapper;
        }
    }

    protected Map<AbstractVariable, AbstractVariable> getMapping() {
        return this.mapping;
    }

    @Override
    public void visitVariable(Variable variable) {
        ConstraintSyntaxTree var = null;
        if (this.replacer != null) {
            var = this.replacer.mapLeaf(variable);
        }
        if (var == null) {
            var = new Variable(this.mapVariable(variable.getVariable()));
        }
        this.setResult(var);
    }

    @Override
    protected DecisionVariableDeclaration mapVariable(DecisionVariableDeclaration var) {
        AbstractVariable tmp;
        DecisionVariableDeclaration result = null;
        if (this.mapping != null && (tmp = this.mapping.get(var)) instanceof DecisionVariableDeclaration) {
            result = var;
        }
        if (result == null && this.mapper != null && (tmp = this.mapper.map((IVariable)var)) instanceof DecisionVariableDeclaration) {
            result = var;
        }
        if (result == null) {
            result = var;
        }
        return result;
    }

    @Override
    protected AbstractVariable mapVariable(AbstractVariable var) {
        AbstractVariable result = null;
        if (this.mapping != null) {
            result = this.mapping.get(var);
            if (result == null) {
                result = var;
            }
        } else {
            result = var;
        }
        return result;
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        ConstraintSyntaxTree var = null;
        if (this.replacer != null) {
            var = this.replacer.mapLeaf(variable);
        }
        if (var == null) {
            super.visitAnnotationVariable(variable);
            var = this.getResult();
        }
        this.setResult(var);
    }

    @Override
    public void visitSelf(Self self) {
        ConstraintSyntaxTree cst = this.replacer.mapSelf(self);
        if (cst != null) {
            this.setResult(cst);
        } else {
            super.visitSelf(self);
        }
    }

    public static interface IVariableReplacer
    extends IVersionRestriction.IVariableMapper {
        public ConstraintSyntaxTree mapLeaf(Variable var1);

        public ConstraintSyntaxTree mapSelf(Self var1);
    }
}

