/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.pool.IPoolManager;
import net.ssehub.easy.basics.pool.Pool;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.AbstractDecisionVariableEvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationContext;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.cstEvaluation.IValueChangeListener;
import net.ssehub.easy.varModel.model.values.Value;

class ContainerElementAccessor
extends AbstractDecisionVariableEvaluationAccessor {
    public static final Pool<ContainerElementAccessor> POOL = new Pool((IPoolManager)new IPoolManager<ContainerElementAccessor>(){

        public ContainerElementAccessor create() {
            return new ContainerElementAccessor();
        }

        public void clear(ContainerElementAccessor instance) {
            instance.clear();
        }
    });
    private IDecisionVariable elementVariable;

    private ContainerElementAccessor() {
    }

    public ContainerElementAccessor bind(IDecisionVariable variable, int index, EvaluationContext context) {
        super.bind(variable, context);
        this.elementVariable = variable.getNestedElement(index);
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.elementVariable = null;
    }

    @Override
    public Value getValue() {
        Value result = this.elementVariable != null ? this.elementVariable.getValue() : null;
        return result;
    }

    @Override
    public boolean setValue(Value value, boolean asAssignment) {
        boolean successful = false;
        EvaluationContext context = this.getContext();
        if (context.allowAssignValues() && this.elementVariable != null) {
            if (value == null) {
                context.addErrorMessage("assignable value is not defined", 102);
            } else {
                Value oldValue = this.elementVariable.getValue();
                IAssignmentState oldState = this.elementVariable.getState();
                if (!Value.equalsPartially(oldValue, value) && oldState != AssignmentState.USER_ASSIGNED) {
                    IAssignmentState targetState = context.getTargetState(this.elementVariable);
                    if (targetState != null) {
                        try {
                            this.elementVariable.setValue(value, targetState, asAssignment);
                            successful = true;
                            this.notifyVariableChange(oldValue, oldState, IValueChangeListener.ChangeKind.FULL);
                        }
                        catch (ConfigurationException e) {
                            context.addErrorMessage(e);
                        }
                    } else {
                        context.addMessage(new EvaluationVisitor.Message("Assignment state conflict", Status.ERROR, this.elementVariable, 101));
                    }
                } else {
                    successful = true;
                }
                this.elementVariable.notifyWasAssigned(value);
            }
        }
        return successful;
    }

    @Override
    public void release() {
        POOL.releaseInstance((Object)this);
    }

    @Override
    public boolean isAssignable() {
        return true;
    }
}

