/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationUtils;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.Value;

public class DispatchInformation {
    private CustomOperation operation;
    private IDatatype[] argTypes;
    private int bestDiff;
    private CustomOperation bestMatch;
    private Set<String> candidates;
    private Set<Project> doneProjects;
    private String opName;
    private int opParamCount;
    private IDatatype returnType;
    private int overrideCount;
    private int dispatchBasisCount;
    private boolean countAnnotations;

    DispatchInformation(CustomOperation operation, EvaluationAccessor[] args) {
        this(operation, DispatchInformation.getArgTypes(args), false);
    }

    public DispatchInformation(CustomOperation operation, IDatatype[] argTypes, boolean countAnnotations) {
        this.operation = operation;
        this.countAnnotations = countAnnotations;
        this.opName = operation.getName();
        this.opParamCount = operation.getParameterCount();
        this.returnType = operation.getReturns();
        this.argTypes = argTypes;
        this.bestMatch = operation;
        this.bestDiff = EvaluationUtils.calculateDiff(operation, this.returnType, argTypes);
        this.candidates = new HashSet<String>();
        this.candidates.add(operation.getSignature());
        this.updateCounts(operation);
        this.doneProjects = new HashSet<Project>();
    }

    private static IDatatype[] getArgTypes(EvaluationAccessor[] args) {
        IDatatype[] argTypes = new IDatatype[args.length];
        int a = 0;
        int n = args.length;
        while (a < n) {
            Value val = args[a].getValue();
            if (val != null) {
                argTypes[a] = val.getType();
            } else if (args[a].getVariable() != null) {
                argTypes[a] = args[a].getVariable().getDeclaration().getType();
            }
            ++a;
        }
        return argTypes;
    }

    public CustomOperation getBestMatch() {
        return this.bestMatch;
    }

    public void checkForDispatch(Project scope) {
        if (!this.doneProjects.contains(scope)) {
            this.doneProjects.add(scope);
            int o = 0;
            int n = scope.getOperationCount();
            while ((this.bestDiff > 0 || this.countAnnotations) && o < n) {
                int diff;
                String tmpSignature;
                CustomOperation tmp = scope.getOperation(o);
                if (tmp != this.operation && this.opName.equals(tmp.getName()) && this.opParamCount == tmp.getParameterCount() && !this.candidates.contains(tmpSignature = tmp.getSignature()) && (diff = EvaluationUtils.calculateDiff(tmp, this.returnType, this.argTypes)) >= 0) {
                    this.candidates.add(tmpSignature);
                    if (diff < this.bestDiff) {
                        this.bestMatch = tmp;
                        this.bestDiff = diff;
                    }
                    this.updateCounts(tmp);
                }
                ++o;
            }
            int i = 0;
            n = scope.getImportsCount();
            while ((this.bestDiff > 0 || this.countAnnotations) && i < n) {
                Project imp = (Project)scope.getImport(i).getResolved();
                if (imp != null) {
                    this.checkForDispatch(imp);
                }
                ++i;
            }
        }
    }

    private void updateCounts(CustomOperation op) {
        if (this.countAnnotations) {
            this.overrideCount += op.hasAnnotation("override") ? 1 : 0;
            this.dispatchBasisCount += op.hasAnnotation("dispatchBasis") ? 1 : 0;
        }
    }

    public int getOverrideCount() {
        return this.overrideCount;
    }

    public int getDispatchBasisCount() {
        return this.dispatchBasisCount;
    }

    public int getCandidatesCount() {
        return this.candidates.size();
    }
}

