/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.modelManagement.IVariable;
import net.ssehub.easy.varModel.Bundle;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.CopyVisitor;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;

class EvaluationUtils {
    EvaluationUtils() {
    }

    static String createSpaces(int count) {
        Object res = "";
        int i = 1;
        while (i <= count) {
            res = (String)res + " ";
            ++i;
        }
        return res;
    }

    static void release(EvaluationAccessor[] accessors) {
        int a = 0;
        while (a < accessors.length) {
            if (accessors[a] != null) {
                accessors[a].release();
            }
            ++a;
        }
    }

    static Compound getDeclaringCompound(AbstractVariable decl) {
        IModelElement parent = decl.getParent();
        while (!(parent instanceof Project) && !(parent instanceof Compound)) {
            parent = parent.getParent();
        }
        return parent instanceof Compound ? (Compound)parent : null;
    }

    static Map<IDatatype, List<AbstractVariable>> groupQuantors(Iterator<AbstractVariable> staticIter) {
        HashMap<IDatatype, List<AbstractVariable>> iterGroups = new HashMap<IDatatype, List<AbstractVariable>>();
        while (staticIter.hasNext()) {
            AbstractVariable var = staticIter.next();
            Compound declaring = EvaluationUtils.getDeclaringCompound(var);
            if (declaring == null) continue;
            ArrayList<AbstractVariable> group = (ArrayList<AbstractVariable>)iterGroups.get(declaring);
            if (group == null) {
                group = new ArrayList<AbstractVariable>();
                iterGroups.put(declaring, group);
            }
            group.add(var);
        }
        return iterGroups;
    }

    static IDecisionVariable findAttribute(IDecisionVariable var, AbstractVariable decl, boolean byName) {
        IDecisionVariable result = null;
        if (var != null) {
            int a = 0;
            int n = var.getAttributesCount();
            while (result == null && a < n) {
                IDecisionVariable attribute = var.getAttribute(a);
                if (byName && attribute.getDeclaration().getName().equals(decl.getName())) {
                    result = attribute;
                } else if (!byName && attribute.getDeclaration().equals(decl)) {
                    result = attribute;
                }
                ++a;
            }
        }
        return result;
    }

    static int calculateDiff(CustomOperation operation, IDatatype returns, IDatatype[] argTypes) {
        int diff = EvaluationUtils.diff(returns, operation.getReturns());
        if (diff >= 0) {
            int a = 0;
            int n = argTypes.length;
            while (diff >= 0 && a < n) {
                int tmp = EvaluationUtils.diff(operation.getParameterType(a).getType(), argTypes[a]);
                diff = tmp < 0 ? -1 : (diff += tmp);
                ++a;
            }
        }
        return diff;
    }

    private static int diff(IDatatype opType, IDatatype paramType) {
        int result = -1;
        if (opType.isAssignableFrom(paramType)) {
            if (paramType.isAssignableFrom(opType)) {
                result = 0;
            } else {
                result = 1;
                if (Compound.TYPE.isAssignableFrom(paramType)) {
                    result += EvaluationUtils.diff((Compound)paramType, opType);
                }
                if (Container.TYPE.isAssignableFrom(opType) && Container.TYPE.isAssignableFrom(paramType)) {
                    result = EvaluationUtils.diffContainer((Container)opType, (Container)paramType);
                }
            }
        }
        if (result != 0 && paramType instanceof Reference) {
            result = EvaluationUtils.diff(opType, Reference.dereference(paramType));
        }
        return result;
    }

    private static int diff(Compound type, IDatatype opType) {
        int result = 0;
        if (!TypeQueries.sameTypes(type, opType)) {
            ++result;
            int r = 0;
            while (r < type.getRefinesCount()) {
                result += EvaluationUtils.diff(type.getRefines(r), opType);
                ++r;
            }
        }
        return result;
    }

    private static int diffContainer(Container opCont, Container paramCont) {
        int paramContGen;
        int result = 0;
        int opContGen = opCont.getGenericTypeCount();
        if (opContGen != (paramContGen = paramCont.getGenericTypeCount())) {
            result = -1;
        } else {
            int i = 0;
            while (i < opContGen) {
                int tmp = EvaluationUtils.diff(opCont.getGenericType(i), paramCont.getGenericType(i));
                if (tmp < 0) {
                    result = -1;
                    break;
                }
                result += tmp;
                ++i;
            }
        }
        return result;
    }

    static class VariableReplacer
    implements CopyVisitor.IVariableReplacer {
        private Variable iter;
        private List<AbstractVariable> decls;

        VariableReplacer(DecisionVariableDeclaration iter, List<AbstractVariable> decls) {
            this.iter = new Variable(iter);
            try {
                this.iter.inferDatatype();
            }
            catch (CSTSemanticException e) {
                Bundle.getLogger(EvaluationVisitor.class).exception((Exception)e);
            }
            this.decls = decls;
        }

        public IVariable map(IVariable variable) {
            return null;
        }

        @Override
        public ConstraintSyntaxTree mapLeaf(Variable variable) {
            CompoundAccess result = null;
            AbstractVariable var = variable.getVariable();
            int i = 0;
            while (result == null && i < this.decls.size()) {
                if (this.decls.get(i) == var) {
                    result = new CompoundAccess(this.iter, var.getName());
                }
                ++i;
            }
            return result;
        }

        @Override
        public ConstraintSyntaxTree mapSelf(Self self) {
            return null;
        }
    }
}

