/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.Value;

public class StaticAccessFinder
implements IConstraintTreeVisitor {
    private Self self = null;
    private Set<AbstractVariable> result = new HashSet<AbstractVariable>();
    private Set<DecisionVariableDeclaration> defined = new HashSet<DecisionVariableDeclaration>();

    public Iterator<AbstractVariable> getResults() {
        return this.result.iterator();
    }

    public Self getSelf() {
        return this.self;
    }

    public void clear() {
        this.result.clear();
        this.self = null;
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
    }

    @Override
    public void visitVariable(Variable variable) {
        AbstractVariable var = variable.getVariable();
        if (!this.defined.contains(var) && variable.getQualifier() == null && var instanceof DecisionVariableDeclaration) {
            IModelElement par = var.getParent();
            while (par != null && par instanceof AttributeAssignment) {
                par = par.getParent();
            }
            if (par instanceof Compound) {
                this.result.add((DecisionVariableDeclaration)var);
            }
        }
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        parenthesis.getExpr().accept(this);
    }

    @Override
    public void visitComment(Comment comment) {
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        if (call.getOperand() != null) {
            call.getOperand().accept(this);
        }
        int p = 0;
        int n = call.getParameterCount();
        while (p < n) {
            call.getParameter(p).accept(this);
            ++p;
        }
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        int e = 0;
        int n = expression.getExpressionCount();
        while (e < n) {
            expression.getExpression(e).accept(this);
            ++e;
        }
    }

    @Override
    public void visitLet(Let let) {
        this.defined.add(let.getVariable());
        let.getInExpression().accept(this);
        this.defined.remove(let.getVariable());
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        ifThen.getIfExpr().accept(this);
        ifThen.getThenExpr().accept(this);
        if (ifThen.getElseExpr() != null) {
            ifThen.getElseExpr().accept(this);
        }
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        int d = 0;
        while (d < call.getDeclaratorsCount()) {
            this.defined.add(call.getDeclarator(d));
            ++d;
        }
        call.getContainer().accept(this);
        call.getExpression().accept(this);
        d = 0;
        while (d < call.getDeclaratorsCount()) {
            this.defined.remove(call.getDeclarator(d));
            ++d;
        }
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        ConstantValue cValue;
        Value value;
        ConstraintSyntaxTree cEx;
        AbstractVariable decl = access.getResolvedSlot();
        if (!this.defined.contains(decl) && (cEx = access.getCompoundExpression()) instanceof ConstantValue && (value = (cValue = (ConstantValue)cEx).getConstantValue()) instanceof MetaTypeValue) {
            this.result.add(decl);
        }
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        Compound type = initializer.getType();
        int i = 0;
        int n = initializer.getExpressionCount();
        while (i < n) {
            String slotName = initializer.getSlot(i);
            DecisionVariableDeclaration decl = type.getElement(slotName);
            if (decl != null && !ConstraintType.TYPE.isAssignableFrom(decl.getType())) {
                initializer.getExpression(i).accept(this);
            }
            ++i;
        }
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        if (!Container.isContainer(initializer.getType(), ConstraintType.TYPE)) {
            int i = 0;
            int n = initializer.getExpressionCount();
            while (i < n) {
                initializer.getExpression(i).accept(this);
                ++i;
            }
        }
    }

    @Override
    public void visitSelf(Self self) {
        this.self = self;
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable(variable);
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        int e = 0;
        int n = block.getExpressionCount();
        while (e < n) {
            block.getExpression(e).accept(this);
            ++e;
        }
    }
}

