/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.EvaluationBlock;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.filter.DeclarationInContainerFinder;

public class BasicDecisionVariableContainer
extends ModelElement
implements IDecisionVariableContainer {
    private List<DecisionVariableDeclaration> elements = new ArrayList<DecisionVariableDeclaration>();
    private List<Constraint> constraints = new ArrayList<Constraint>();
    private List<AttributeAssignment> assignments = null;
    private List<ContainableModelElement> modelElements = new ArrayList<ContainableModelElement>();
    private Set<String> names = new HashSet<String>();
    private List<DecisionVariableDeclaration> allDeclarations = null;

    public BasicDecisionVariableContainer() {
        super(null);
    }

    @Override
    public void sortContainedElements(Comparator<ContainableModelElement> comp) {
        assert (comp != null);
        int size = this.modelElements.size();
        Collections.sort(this.modelElements, comp);
        assert (this.modelElements.size() == size);
    }

    @Override
    public void add(AttributeAssignment assignment) {
        assert (assignment != null);
        if (this.assignments == null) {
            this.assignments = new ArrayList<AttributeAssignment>();
        }
        this.assignments.add(assignment);
        this.modelElements.add(assignment);
        this.allDeclarations = null;
    }

    @Override
    public void forceUpdate() {
        this.allDeclarations = null;
        int i = 0;
        int end = this.modelElements.size();
        while (i < end) {
            ContainableModelElement element = this.modelElements.get(i);
            if (element instanceof IDecisionVariableContainer) {
                ((IDecisionVariableContainer)((Object)element)).forceUpdate();
            }
            ++i;
        }
    }

    @Override
    public void add(EvaluationBlock eval) {
        assert (eval != null);
        this.modelElements.add(eval);
    }

    @Override
    public int getAssignmentCount() {
        return this.assignments == null ? 0 : this.assignments.size();
    }

    @Override
    public AttributeAssignment getAssignment(int index) {
        if (this.assignments == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.assignments.get(index);
    }

    @Override
    public ContainableModelElement getModelElement(int index) {
        return this.modelElements.get(index);
    }

    @Override
    public int getModelElementCount() {
        return this.modelElements.size();
    }

    @Override
    public DecisionVariableDeclaration getElement(String name) {
        DecisionVariableDeclaration result = null;
        int e = 0;
        while (result == null && e < this.elements.size()) {
            DecisionVariableDeclaration element = this.elements.get(e);
            if (element != null && (element.getName().equals(name) || element.getQualifiedName().equals(name))) {
                result = element;
            }
            ++e;
        }
        if (result == null) {
            int a = 0;
            while (result == null && a < this.getAssignmentCount()) {
                result = this.getAssignment(a).getElement(name);
                ++a;
            }
        }
        return result;
    }

    @Override
    public boolean contains(DecisionVariableDeclaration var) {
        boolean found = this.containsByName(var.getName());
        int e = 0;
        while (!found && e < this.elements.size()) {
            found = this.elements.get(e).isSame(var);
            ++e;
        }
        int a = 0;
        while (!found && a < this.getAssignmentCount()) {
            found = this.getAssignment(a).contains(var);
            ++a;
        }
        return found;
    }

    @Override
    public boolean containsByName(String name) {
        return name != null && this.names.contains(name);
    }

    @Override
    public void add(Comment comment) {
        if (comment != null) {
            this.modelElements.add(comment);
        }
    }

    @Override
    public int getElementCount() {
        return this.elements.size();
    }

    @Override
    public DecisionVariableDeclaration getElement(int index) {
        return this.elements.get(index);
    }

    @Override
    public boolean add(DecisionVariableDeclaration elem) {
        assert (elem != null);
        boolean found = this.contains(elem);
        if (!found) {
            this.names.add(elem.getName());
            this.elements.add(elem);
            this.modelElements.add(elem);
            this.allDeclarations = null;
        }
        return !found;
    }

    @Override
    public int getConstraintsCount() {
        return this.constraints == null ? 0 : this.constraints.size();
    }

    @Override
    public Constraint getConstraint(int index) {
        if (this.constraints == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.constraints.get(index);
    }

    @Override
    public void addConstraint(Constraint constraint, boolean internal) {
        assert (constraint != null);
        if (this.constraints == null) {
            this.constraints = new ArrayList<Constraint>();
        }
        this.constraints.add(constraint);
        this.modelElements.add(constraint);
        this.allDeclarations = null;
    }

    @Override
    public int getRealizingCount() {
        return 0;
    }

    @Override
    public Constraint getRealizing(int index) {
        throw new IndexOutOfBoundsException("no elements");
    }

    @Override
    public boolean propagateAttribute(Attribute attribute) {
        boolean successful = true;
        int e = 0;
        while (e < this.elements.size()) {
            successful &= this.elements.get(e).propagateAttribute(attribute);
            ++e;
        }
        if (this.assignments != null) {
            int a = 0;
            while (a < this.assignments.size()) {
                successful &= this.assignments.get(a).propagateAttribute(attribute);
                ++a;
            }
        }
        return successful;
    }

    @Override
    public void accept(IModelVisitor visitor) {
    }

    @Override
    public int getDeclarationCount() {
        if (this.allDeclarations == null) {
            this.allDeclarations = new ArrayList<DecisionVariableDeclaration>();
            int i = 0;
            while (i < this.modelElements.size()) {
                DeclarationInContainerFinder finder = new DeclarationInContainerFinder(this.modelElements.get(i));
                this.allDeclarations.addAll(finder.getDeclarations());
                ++i;
            }
        }
        return this.allDeclarations.size();
    }

    @Override
    public DecisionVariableDeclaration getDeclaration(int index) {
        return this.allDeclarations.get(index);
    }

    public boolean removeModelElement(ContainableModelElement element) {
        boolean found = false;
        if (element != null) {
            if (element instanceof Constraint) {
                found = this.constraints.remove(element);
            } else if (element instanceof DecisionVariableDeclaration) {
                found = this.elements.remove(element);
                if (found) {
                    this.allDeclarations = null;
                }
            } else if (element instanceof AttributeAssignment) {
                found = this.assignments.remove(element);
            }
            if (found) {
                found |= this.modelElements.remove(element);
            }
        }
        return found;
    }

    @Override
    public String toString() {
        return this.modelElements.toString();
    }
}

