/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite;

import java.util.ArrayList;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.rewrite.RewriteContext;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.model.values.VersionValue;

class ValueCopy
implements IValueVisitor {
    private Value copiedValue;
    private boolean valuesOmmited;
    private RewriteContext context;

    ValueCopy(RewriteContext context, Value value) {
        this.context = context;
        this.valuesOmmited = false;
        value.accept(this);
    }

    Value getValue() {
        return this.copiedValue;
    }

    boolean valuesOmitted() {
        return this.valuesOmmited;
    }

    @Override
    public void visitConstraintValue(ConstraintValue value) {
    }

    @Override
    public void visitEnumValue(EnumValue value) {
        this.copiedValue = value;
    }

    @Override
    public void visitStringValue(StringValue value) {
        this.copiedValue = value;
    }

    @Override
    public void visitCompoundValue(CompoundValue value) {
        Compound cType = (Compound)value.getType();
        ArrayList<Object> copiedValues = new ArrayList<Object>();
        int i = 0;
        int n = cType.getInheritedElementCount();
        while (i < n) {
            String slotName = cType.getInheritedElement(i).getName();
            Value nestedValue = value.getNestedValue(slotName);
            if (nestedValue != null) {
                nestedValue.accept(this);
                if (this.copiedValue != null) {
                    copiedValues.add(slotName);
                    copiedValues.add(this.copiedValue);
                }
            }
            ++i;
        }
        if (!this.valuesOmmited) {
            this.copiedValue = value;
        } else if (!copiedValues.isEmpty() && this.valuesOmmited) {
            try {
                this.copiedValue = ValueFactory.createValue(cType, copiedValues.toArray());
            }
            catch (ValueDoesNotMatchTypeException e) {
                this.copiedValue = value;
                EASyLoggerFactory.INSTANCE.getLogger(ValueCopy.class, "net.ssehub.easy.varModel").exception((Exception)e);
            }
        } else if (copiedValues.isEmpty()) {
            try {
                this.copiedValue = ValueFactory.createValue(cType, null);
            }
            catch (ValueDoesNotMatchTypeException e) {
                this.copiedValue = value;
                EASyLoggerFactory.INSTANCE.getLogger(ValueCopy.class, "net.ssehub.easy.varModel").exception((Exception)e);
            }
        }
    }

    @Override
    public void visitContainerValue(ContainerValue value) {
        ArrayList<Value> copiedValues = new ArrayList<Value>();
        int i = 0;
        int n = value.getElementSize();
        while (i < n) {
            value.getElement(i).accept(this);
            if (this.copiedValue != null) {
                copiedValues.add(this.copiedValue);
            }
            ++i;
        }
        if (!this.valuesOmmited) {
            this.copiedValue = value;
        } else if (!copiedValues.isEmpty() && this.valuesOmmited) {
            try {
                this.copiedValue = ValueFactory.createValue(value.getType(), copiedValues.toArray());
            }
            catch (ValueDoesNotMatchTypeException e) {
                this.copiedValue = value;
                EASyLoggerFactory.INSTANCE.getLogger(ValueCopy.class, "net.ssehub.easy.varModel").exception((Exception)e);
            }
        } else if (copiedValues.isEmpty()) {
            try {
                this.copiedValue = ValueFactory.createValue(value.getType(), null);
            }
            catch (ValueDoesNotMatchTypeException e) {
                this.copiedValue = value;
                EASyLoggerFactory.INSTANCE.getLogger(ValueCopy.class, "net.ssehub.easy.varModel").exception((Exception)e);
            }
        }
    }

    @Override
    public void visitIntValue(IntValue value) {
        this.copiedValue = value;
    }

    @Override
    public void visitRealValue(RealValue value) {
        this.copiedValue = value;
    }

    @Override
    public void visitBooleanValue(BooleanValue value) {
        this.copiedValue = value;
    }

    @Override
    public void visitReferenceValue(ReferenceValue referenceValue) {
        AbstractVariable referencedDecl = referenceValue.getValue();
        if (referencedDecl != null && this.context.elementWasRemoved(referencedDecl)) {
            this.copiedValue = null;
            this.valuesOmmited = true;
        } else {
            this.copiedValue = referenceValue;
        }
    }

    @Override
    public void visitMetaTypeValue(MetaTypeValue value) {
        this.copiedValue = value;
    }

    @Override
    public void visitNullValue(NullValue value) {
        this.copiedValue = value;
    }

    @Override
    public void visitVersionValue(VersionValue value) {
        this.copiedValue = value;
    }
}

