/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.values;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.StructuredValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class ContainerValue
extends StructuredValue
implements Cloneable {
    private List<Value> nestedElements = new ArrayList<Value>();

    ContainerValue() {
    }

    ContainerValue(Container container, Object ... value) throws ValueDoesNotMatchTypeException {
        this(container, true, value);
    }

    public ContainerValue(Container container, boolean check, Object ... value) throws ValueDoesNotMatchTypeException {
        this(container);
        if (check && this.duplicateValues(value)) {
            throw new ValueDoesNotMatchTypeException("Duplicates in '" + Arrays.toString(value) + "' are not allowed for a Set.", 10207);
        }
        int i = 0;
        while (value != null && i < value.length) {
            if (value[i] != null) {
                if (value[i] instanceof Value) {
                    Value v = (Value)value[i];
                    if (!container.getContainedType().isAssignableFrom(v.getType())) {
                        throw new ValueDoesNotMatchTypeException(v.getValue(), container.getContainedType().getName(), 10203);
                    }
                    this.nestedElements.add(v);
                } else if (value[i].getClass().isArray()) {
                    this.nestedElements.add(ValueFactory.createValue(container.getContainedType(), (Object[])value[i]));
                } else {
                    this.nestedElements.add(ValueFactory.createValue(container.getContainedType(), value[i]));
                }
            }
            ++i;
        }
    }

    protected ContainerValue(Container container, ContainerValue source) throws ValueDoesNotMatchTypeException {
        this(container);
        this.copyValuesFrom(source);
    }

    ContainerValue(Container container) {
        super(container);
    }

    @Override
    public IDatatype getContainedType() {
        IDatatype type = this.getType();
        type = 1 == type.getGenericTypeCount() ? type.getGenericType(0) : null;
        return type;
    }

    @Override
    public Object getValue() {
        Object[] result = null;
        if (this.nestedElements != null) {
            result = new Object[this.nestedElements.size()];
            this.nestedElements.toArray(result);
        }
        return result;
    }

    public String nestedValuesToString() {
        StringBuffer str = new StringBuffer();
        str.append("{");
        int i = 0;
        while (i < this.nestedElements.size() - 1) {
            str.append(this.getElement(i));
            str.append(", ");
            ++i;
        }
        if (!this.nestedElements.isEmpty()) {
            str.append(this.getElement(this.nestedElements.size() - 1));
        }
        str.append("}");
        return str.toString();
    }

    @Override
    public String toString() {
        return this.nestedValuesToString() + " : " + this.getType().toString();
    }

    @Override
    public void accept(IValueVisitor visitor) {
        visitor.visitContainerValue(this);
    }

    @Override
    public void setValue(Object value) throws ValueDoesNotMatchTypeException {
        if (value instanceof ContainerValue) {
            this.copyValuesFrom((ContainerValue)value);
        } else if (value == null) {
            this.nestedElements.clear();
        } else if (value != null) {
            throw new ValueDoesNotMatchTypeException("<not implemented>", this, 10204);
        }
    }

    @Override
    public boolean isFullyConfigured() {
        boolean fullyConfigured = true;
        int i = 0;
        while (fullyConfigured && i < this.nestedElements.size()) {
            if (this.nestedElements.get(i) != null) {
                fullyConfigured = this.nestedElements.get(i).isConfigured();
            }
            ++i;
        }
        return fullyConfigured;
    }

    public void copyValuesFrom(ContainerValue source) throws ValueDoesNotMatchTypeException {
        int i;
        if (this.isSetValue()) {
            i = 0;
            while (i < source.getElementSize()) {
                if (this.nestedElements.contains(source.getElement(i))) {
                    StringBuffer message = new StringBuffer("Duplicate value for ");
                    message.append(this.getType().getName());
                    message.append(": ");
                    message.append(StringProvider.toIvmlString(source.getElement(i)));
                    throw new ValueDoesNotMatchTypeException(message.toString(), 10207);
                }
                ++i;
            }
        }
        i = 0;
        while (i < source.getElementSize()) {
            this.nestedElements.add(source.getElement(i));
            ++i;
        }
    }

    @Override
    public ContainerValue clone() {
        ContainerValue clonedValue = (ContainerValue)super.clone();
        clonedValue.nestedElements = new ArrayList<Value>();
        int i = 0;
        while (i < this.nestedElements.size()) {
            Value clonedNestedValue = this.nestedElements.get(i).clone();
            clonedValue.nestedElements.add(clonedNestedValue);
            ++i;
        }
        return clonedValue;
    }

    public int getElementSize() {
        return this.nestedElements.size();
    }

    public Value getElement(int index) {
        return this.nestedElements.get(index);
    }

    public int indexOf(Value value) {
        return this.nestedElements.indexOf(value);
    }

    private boolean isSetValue() {
        return Set.TYPE.isAssignableFrom(this.getType());
    }

    private boolean duplicateValues(Object[] values) {
        boolean duplicatesFound = false;
        if (this.isSetValue() && values != null) {
            int i = 0;
            while (!duplicatesFound && i < values.length - 1) {
                if (values[i] != null) {
                    int j = i + 1;
                    while (!duplicatesFound && j < values.length) {
                        if (values[i].equals(values[j]) && !(values[i] instanceof CompoundValue) && !(values[i] instanceof ContainerValue)) {
                            duplicatesFound = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return duplicatesFound;
    }

    public void setValue(int index, Value nestedValue) throws ValueDoesNotMatchTypeException {
        if (index >= this.nestedElements.size()) {
            if (this.isSetValue() && nestedValue != null) {
                boolean duplicateFound = false;
                int i = 0;
                while (i < this.nestedElements.size() && !duplicateFound) {
                    if (nestedValue.equals(this.nestedElements.get(i))) {
                        throw new ValueDoesNotMatchTypeException("'" + nestedValue.getValue().toString() + "' already contained and duplicates are not allowed for a Sets.", 10207);
                    }
                    ++i;
                }
            }
            this.nestedElements.add(nestedValue);
        } else {
            if (this.isSetValue() && nestedValue != null) {
                boolean duplicateFound = false;
                int i = 0;
                while (i < this.nestedElements.size() && !duplicateFound) {
                    if (i != index && nestedValue.equals(this.nestedElements.get(i))) {
                        throw new ValueDoesNotMatchTypeException("'" + nestedValue.getValue().toString() + "' already contained and duplicates are not allowed for a Sets.", 10207);
                    }
                    ++i;
                }
            }
            this.nestedElements.set(index, nestedValue);
        }
    }

    @Override
    public int hashCode() {
        int result;
        if (Sequence.TYPE.isAssignableFrom(this.getType())) {
            result = this.nestedElements.hashCode();
        } else {
            result = 0;
            int i = 0;
            while (i < this.nestedElements.size()) {
                Value val = this.nestedElements.get(i);
                if (val != null) {
                    result += val.hashCode();
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        boolean equals = false;
        if (other instanceof ContainerValue) {
            int opSize;
            ContainerValue oContainer = (ContainerValue)other;
            if (this.getType().isAssignableFrom(oContainer.getType()) && (opSize = this.getElementSize()) == oContainer.getElementSize()) {
                equals = true;
                if (Sequence.TYPE.isAssignableFrom(this.getType())) {
                    equals = this.nestedElements.equals(oContainer.nestedElements);
                } else {
                    HashSet<Value> tmp = new HashSet<Value>();
                    this.doAll(tmp, true);
                    oContainer.doAll(tmp, false);
                    equals = tmp.isEmpty();
                }
            }
        }
        return equals;
    }

    private void doAll(HashSet<Value> set, boolean add) {
        int size = this.getElementSize();
        int e = 0;
        while (e < size) {
            Value value = this.getElement(e);
            if (value != null) {
                if (add) {
                    set.add(value);
                } else {
                    set.remove(value);
                }
            }
            ++e;
        }
    }

    public void addElement(int pos, Value value) throws ValueDoesNotMatchTypeException {
        if (this.isSetValue()) {
            throw new ValueDoesNotMatchTypeException("no index access for sets", 10207);
        }
        this.checkContainedType(value);
        this.nestedElements.add(pos, value);
    }

    private void checkContainedType(Value value) throws ValueDoesNotMatchTypeException {
        if (!this.getContainedType().isAssignableFrom(value.getType())) {
            throw new ValueDoesNotMatchTypeException("cannot assign value of type '" + IvmlDatatypeVisitor.getQualifiedType(value.getType()) + "' to '" + IvmlDatatypeVisitor.getQualifiedType(this.getContainedType()) + "'", 10203);
        }
    }

    public void addElement(Value value) throws ValueDoesNotMatchTypeException {
        this.checkContainedType(value);
        boolean add = true;
        if (this.isSetValue()) {
            boolean bl = add = !this.nestedElements.contains(value);
        }
        if (add) {
            this.nestedElements.add(value);
        }
    }

    public void removeElement(Value value) {
        this.nestedElements.remove(value);
    }

    public void removeElement(int index) {
        this.nestedElements.remove(index);
    }

    @Override
    public boolean equalsPartially(Value value) {
        return this.equals(value);
    }

    public void clear() {
        this.nestedElements.clear();
    }

    public Iterator<Value> iterator() {
        return this.nestedElements.iterator();
    }
}

