/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.CompoundVariable;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.ContainerVariable;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.VariableConfigProvider;
import net.ssehub.easy.varModel.confModel.VariableCreator;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

class ToplevelVarConfigProvider
extends VariableConfigProvider {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ToplevelVarConfigProvider.class, "net.ssehub.easy.varModel");
    private Value value;
    private IAssignmentState state;
    private IDecisionVariable relatedVariable;

    protected ToplevelVarConfigProvider(IDecisionVariable relatedVariable, Value value, IAssignmentState state) {
        this.relatedVariable = relatedVariable;
        this.setValueImpl(value);
        this.state = state == null ? AssignmentState.UNDEFINED : state;
    }

    @Override
    protected Value getValue() {
        return this.value;
    }

    @Override
    protected void setValue(Value value, IAssignmentState state) throws ConfigurationException {
        if (this.state != AssignmentState.FROZEN) {
            this.assignValue(value, state, false);
        } else if (this.value == null && this.state == AssignmentState.FROZEN && value != null && !value.isConfigured()) {
            this.setValueImpl(value);
        } else {
            throw new ConfigurationException(this.getConfiguration(), "decision '" + this.getDeclaration().getName() + "' is already frozen and cannot be changed", 19001);
        }
    }

    @Override
    protected IAssignmentState getState() {
        return this.state;
    }

    @Override
    protected final void setState(IAssignmentState state) {
        this.state = state;
        this.getConfiguration().variableChangedState(this.relatedVariable);
    }

    @Override
    protected final boolean isStateChangeAllowed() {
        return true;
    }

    @Override
    protected final AbstractVariable getDeclaration() {
        return this.relatedVariable.getDeclaration();
    }

    @Override
    protected final Configuration getConfiguration() {
        return this.relatedVariable.getConfiguration();
    }

    @Override
    protected void setHistoryValue(Value value, IAssignmentState state) throws ConfigurationException {
        this.assignValue(value, state, true);
    }

    private void assignValue(Value value, IAssignmentState state, boolean allowDeletation) throws ConfigurationException {
        Value oldValue = this.value;
        if (value != null) {
            if (!this.getDeclaration().getType().isAssignableFrom(value.getType())) {
                throw new ConfigurationException(this.getConfiguration(), "type '" + IvmlDatatypeVisitor.getQualifiedType(this.getDeclaration().getType()) + "' of variable declaration '" + this.getDeclaration().getName() + "' does not match type of value '" + IvmlDatatypeVisitor.getQualifiedType(value.getType()) + "'", 19002);
            }
            if (value instanceof CompoundValue && oldValue != null && oldValue instanceof CompoundValue) {
                value = this.assignCompoundValue((CompoundValue)value, state, allowDeletation, (CompoundValue)oldValue);
            } else if (value instanceof ContainerValue) {
                value = this.assignContainerValue((ContainerValue)value, state, allowDeletation);
            }
        } else if (this.relatedVariable.getDeclaration().getType() instanceof Container && allowDeletation) {
            ContainerVariable container = (ContainerVariable)this.relatedVariable;
            container.clear();
        }
        this.setValueImpl(value);
        this.state = state;
        this.getConfiguration().variableChanged(this.relatedVariable, oldValue);
    }

    private Value assignCompoundValue(CompoundValue value, IAssignmentState state, boolean allowDeletation, CompoundValue oldValue) throws ConfigurationException {
        IDecisionVariable var;
        CompoundValue newValue = oldValue;
        if (allowDeletation) {
            newValue = value;
        } else {
            try {
                CompoundValue tmpValue = value;
                if (!TypeQueries.sameTypes(value.getType(), oldValue.getType())) {
                    newValue = value;
                    tmpValue = oldValue;
                }
                Compound cType = (Compound)DerivedDatatype.resolveToBasis(this.getDeclaration().getType());
                int i = 0;
                while (i < cType.getInheritedElementCount()) {
                    IAssignmentState oldState;
                    DecisionVariableDeclaration decl = cType.getInheritedElement(i);
                    String name = decl.getName();
                    var = this.relatedVariable.getNestedElement(name);
                    Value newSlotValue = newValue.getNestedValue(name);
                    Value oldSlotValue = tmpValue.getNestedValue(name);
                    IAssignmentState iAssignmentState = oldState = var != null ? var.getState() : state;
                    if (!(oldSlotValue != null && newSlotValue == null || AssignmentState.USER_ASSIGNED == oldState && state != AssignmentState.USER_ASSIGNED)) {
                        newValue.configureValue(name, newSlotValue);
                    }
                    ++i;
                }
            }
            catch (ValueDoesNotMatchTypeException exc) {
                LOGGER.exception((Exception)exc);
            }
        }
        Compound cmpType = (Compound)DerivedDatatype.resolveToBasis(value.getType());
        int i = 0;
        while (i < cmpType.getInheritedElementCount()) {
            String slotName = cmpType.getInheritedElement(i).getName();
            CompoundVariable cmpVar = (CompoundVariable)this.relatedVariable;
            Value nestedValue = value.getNestedValue(slotName);
            var = cmpVar.getNestedVariable(slotName);
            if (var != null) {
                IAssignmentState nestedState = var.getState();
                if (nestedState != AssignmentState.USER_ASSIGNED) {
                    nestedState = state;
                }
                if (allowDeletation) {
                    if (nestedValue == null) {
                        var.setValue(nestedValue, AssignmentState.UNDEFINED);
                    } else {
                        var.setValue(nestedValue, nestedState);
                    }
                } else if (nestedValue != null && var != null && nestedState != AssignmentState.USER_ASSIGNED) {
                    var.setValue(nestedValue, nestedState);
                }
            }
            ++i;
        }
        value = newValue;
        return value;
    }

    private Value assignContainerValue(ContainerValue conValue, IAssignmentState state, boolean allowDeletation) throws ConfigurationException {
        ContainerVariable container = (ContainerVariable)this.relatedVariable;
        if (allowDeletation) {
            container.clear();
        }
        ContainerValue oldValue = null;
        if (this.value instanceof ContainerValue) {
            oldValue = (ContainerValue)this.value;
        }
        this.setValueImpl(conValue);
        int i = 0;
        while (i < conValue.getElementSize()) {
            boolean overwrite = true;
            if (container.getNestedElementsCount() > i) {
                IDecisionVariable oldNestedVar = container.getNestedElement(i);
                boolean bl = overwrite = AssignmentState.USER_ASSIGNED != oldNestedVar.getState() || state == AssignmentState.USER_ASSIGNED;
            }
            if (overwrite) {
                String nestedName = container.getElementName(i);
                DecisionVariableDeclaration nestedDecl = new DecisionVariableDeclaration(nestedName, conValue.getElement(i).getType(), this.relatedVariable.getDeclaration());
                VariableCreator creator = new VariableCreator(nestedDecl, this.relatedVariable, this.relatedVariable.isVisible(), false);
                IDecisionVariable nestedVar = creator.getVariable();
                container.addNestedElement(nestedVar);
                Value nesValue = conValue.getElement(i);
                nestedVar.setValue(nesValue, state);
            } else if (oldValue.getElementSize() > i) {
                try {
                    conValue.setValue(i, oldValue.getElement(i));
                }
                catch (ValueDoesNotMatchTypeException e) {
                    LOGGER.exception((Exception)e);
                }
            }
            ++i;
        }
        return this.value;
    }

    private void setValueImpl(Value value) {
        if (this.value != null) {
            this.value.setValueParent(null);
        }
        this.value = value;
        if (this.value != null) {
            this.value.setValueParent(this.relatedVariable);
        }
    }

    @Override
    protected void freeze(IFreezeSelector selector) {
        this.freeze();
    }
}

