/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cst;

import java.util.Arrays;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public class ContainerInitializer
extends ConstraintSyntaxTree {
    private Container type;
    private ConstraintSyntaxTree[] expressions;

    public ContainerInitializer(Container type, ConstraintSyntaxTree[] expressions) throws CSTSemanticException {
        this.type = type;
        this.expressions = expressions;
        if (expressions == null) {
            throw new CSTSemanticException("expressions is null", 10103);
        }
        IDatatype containedType = type.getContainedType();
        int e = 0;
        while (e < expressions.length) {
            IDatatype eType = expressions[e].inferDatatype();
            if (!containedType.isAssignableFrom(eType)) {
                throw new CSTSemanticException("value " + e + " in initializer is of type '" + IvmlDatatypeVisitor.getQualifiedType(eType) + "' but not of expected type '" + IvmlDatatypeVisitor.getQualifiedType(containedType) + "'", 10100);
            }
            ++e;
        }
    }

    public Container getType() {
        return this.type;
    }

    public int getExpressionCount() {
        return this.expressions.length;
    }

    public ConstraintSyntaxTree getExpression(int index) {
        return this.expressions[index];
    }

    @Override
    public void accept(IConstraintTreeVisitor visitor) {
        visitor.visitContainerInitializer(this);
    }

    @Override
    public IDatatype inferDatatype() throws CSTSemanticException {
        return this.type;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof ContainerInitializer) {
            ContainerInitializer other = (ContainerInitializer)obj;
            equals = this.type.getQualifiedName().equals(other.type.getQualifiedName());
            equals &= Arrays.equals(this.expressions, other.expressions);
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = this.type.getQualifiedName().hashCode();
        return hashCode *= Arrays.hashCode(this.expressions);
    }
}

