/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite.modifier;

import java.util.Iterator;
import java.util.Set;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.filter.DeclrationInConstraintFinder;
import net.ssehub.easy.varModel.model.rewrite.RewriteContext;
import net.ssehub.easy.varModel.model.rewrite.modifier.IModelElementFilter;

public abstract class AbstractFrozenChecker<M extends ContainableModelElement>
implements IModelElementFilter<M> {
    private Configuration config;

    protected AbstractFrozenChecker(Configuration config) {
        this.config = config;
    }

    protected IDecisionVariable getVariable(AbstractVariable declaration) {
        return this.config.getDecision(declaration);
    }

    public final Configuration getConfiguration() {
        return this.config;
    }

    protected boolean constraintIsFrozen(ConstraintSyntaxTree constraint, RewriteContext context) {
        boolean allFrozen = true;
        if (constraint != null) {
            DeclrationInConstraintFinder finder = new DeclrationInConstraintFinder(constraint);
            Set<AbstractVariable> usedDeclarations = finder.getDeclarations();
            Iterator<AbstractVariable> declItr = usedDeclarations.iterator();
            while (declItr.hasNext() && allFrozen) {
                allFrozen = this.allInstancesAreFrozen(declItr.next(), context);
            }
        }
        return allFrozen;
    }

    protected boolean allInstancesAreFrozen(AbstractVariable declaration, RewriteContext context) {
        boolean allFrozen = true;
        Set<IDecisionVariable> instances = context.getInstancesForDeclaration(this.config, declaration);
        if (instances != null) {
            Iterator<IDecisionVariable> varItr = instances.iterator();
            while (varItr.hasNext() && allFrozen) {
                IDecisionVariable usedInstance = varItr.next();
                boolean bl = allFrozen = AssignmentState.FROZEN == usedInstance.getState();
            }
        }
        return allFrozen;
    }
}

