/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.confModel;

import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.varModel.confModel.AbstractConfigurationVisitor;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.AbstractVisitor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;

public abstract class AbstractConfigurationStatisticsVisitor
extends AbstractConfigurationVisitor {
    private ConfigStatistics statistics;
    private AbstractVisitor projectVisitor = new AbstractVisitor(){
        private Set<Project> done = new HashSet<Project>();

        @Override
        public void visitProject(Project project) {
            if (!this.done.contains(project)) {
                this.done.add(project);
                super.visitProject(project);
            }
        }

        @Override
        public void visitEnum(Enum eenum) {
        }

        @Override
        public void visitOrderedEnum(OrderedEnum eenum) {
        }

        @Override
        public void visitCompound(Compound compound) {
        }

        @Override
        public void visitProjectImport(ProjectImport pImport) {
            Project res = (Project)pImport.getResolved();
            if (res != null) {
                res.accept(this);
            }
        }

        @Override
        public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
        }

        @Override
        public void visitAttribute(Attribute attribute) {
        }

        @Override
        public void visitConstraint(Constraint constraint) {
            AbstractConfigurationStatisticsVisitor.this.visitConstraint(constraint);
        }

        @Override
        public void visitFreezeBlock(FreezeBlock freeze) {
        }

        @Override
        public void visitOperationDefinition(OperationDefinition opdef) {
            AbstractConfigurationStatisticsVisitor.this.visitOperationDefinition(opdef);
        }

        @Override
        public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
            AbstractConfigurationStatisticsVisitor.this.processEvalConstraints(block);
        }

        @Override
        public void visitProjectInterface(ProjectInterface iface) {
        }

        @Override
        public void visitComment(Comment comment) {
        }

        @Override
        public void visitAttributeAssignment(AttributeAssignment assignment) {
            AbstractConfigurationStatisticsVisitor.this.visitAssignment(assignment);
        }

        @Override
        public void visitCompoundAccessStatement(CompoundAccessStatement access) {
        }

        @Override
        public void visitDerivedDatatype(DerivedDatatype datatype) {
        }

        @Override
        public void visitEnumLiteral(EnumLiteral literal) {
        }

        @Override
        public void visitReference(Reference reference) {
        }

        @Override
        public void visitSequence(Sequence sequence) {
        }

        @Override
        public void visitSet(net.ssehub.easy.varModel.model.datatypes.Set set) {
        }
    };

    protected AbstractConfigurationStatisticsVisitor(ConfigStatistics statistics) {
        this.statistics = statistics;
    }

    @Override
    public void visitConfiguration(Configuration configuration) {
        Project prj = configuration.getProject();
        prj.accept(this.projectVisitor);
        this.specialTreatment(prj);
        super.visitConfiguration(configuration);
    }

    @Override
    public void visitDecisionVariable(IDecisionVariable variable) {
        ++this.statistics.nToplevelVariables;
        this.visitVariable(variable, false);
    }

    public void visitVariable(IDecisionVariable variable, boolean nestedInContainer) {
        IDatatype dereferedType;
        ++this.statistics.nVariables;
        if (!nestedInContainer) {
            ++this.statistics.nVariablesNoContainers;
        }
        this.statistics.nAnnotations += variable.getAttributesCount();
        this.specialTreatment(variable);
        IDatatype type = variable.getDeclaration().getType();
        if (ConstraintType.TYPE.isAssignableFrom(type)) {
            ++this.statistics.nConstraintVariables;
            if (!nestedInContainer) {
                ++this.statistics.nConstraintVariablesNoContainer;
            }
        } else {
            ++this.statistics.nNormalVariables;
            if (!nestedInContainer) {
                ++this.statistics.nNormalVariablesNoContainer;
            }
        }
        if (Compound.TYPE.isAssignableFrom(type) && (dereferedType = Reference.dereference(type)) instanceof Compound) {
            this.visitRefines((Compound)dereferedType);
        }
        this.visitDefaultValue(variable.getDeclaration().getDefaultValue());
        nestedInContainer |= Container.TYPE.isAssignableFrom(type);
        int i = 0;
        int end = variable.getNestedElementsCount();
        while (i < end) {
            IDecisionVariable nestedVar = variable.getNestedElement(i);
            this.visitVariable(nestedVar, nestedInContainer);
            ++i;
        }
    }

    private void visitRefines(Compound cmp) {
        int r = 0;
        while (r < cmp.getRefinesCount()) {
            Compound cType = cmp.getRefines(r);
            this.visitVariableContainer(cmp);
            int i = 0;
            while (i < cmp.getModelElementCount()) {
                if (cmp.getModelElement(i) instanceof PartialEvaluationBlock) {
                    this.processEvalConstraints((PartialEvaluationBlock)cmp.getModelElement(i));
                }
                ++i;
            }
            this.visitRefines(cType);
            ++r;
        }
    }

    protected void processEvalConstraints(PartialEvaluationBlock evalBlock) {
        int i = 0;
        while (i < evalBlock.getNestedCount()) {
            this.processEvalConstraints(evalBlock.getNested(i));
            ++i;
        }
        i = 0;
        while (i < evalBlock.getEvaluableCount()) {
            if (evalBlock.getEvaluable(i) instanceof Constraint) {
                ++this.statistics.nConstraintInstances;
                this.visitConstraint((Constraint)evalBlock.getEvaluable(i));
            }
            ++i;
        }
    }

    protected void visitVariableContainer(IDecisionVariableContainer cnt) {
        this.statistics.nConstraintInstances += cnt.getConstraintsCount();
        int c = 0;
        while (c < cnt.getConstraintsCount()) {
            this.visitConstraint(cnt.getConstraint(c));
            ++c;
        }
        int a = 0;
        while (a < cnt.getAssignmentCount()) {
            this.visitAssignment(cnt.getAssignment(a));
            ++a;
        }
    }

    protected void visitAssignment(AttributeAssignment assng) {
        this.visitVariableContainer(assng);
    }

    public ConfigStatistics getStatistics() {
        return this.statistics;
    }

    protected abstract void specialTreatment(IDecisionVariable var1);

    protected abstract void specialTreatment(Project var1);

    protected void visitConstraint(Constraint constraint) {
    }

    protected void visitDefaultValue(ConstraintSyntaxTree constraint) {
    }

    protected void visitOperationDefinition(OperationDefinition opdef) {
    }

    public static class ConfigStatistics {
        private int nToplevelVariables = 0;
        private int nVariables = 0;
        private int nVariablesNoContainers = 0;
        private int nNormalVariables = 0;
        private int nNormalVariablesNoContainer = 0;
        private int nConstraintVariables = 0;
        private int nConstraintVariablesNoContainer = 0;
        private int nConstraintInstances = 0;
        private int nAnnotations = 0;

        public int noOfToplevelVariables() {
            return this.nToplevelVariables;
        }

        public int noOfVariables() {
            return this.nVariables;
        }

        public int noOfVariablesWithoutContainer() {
            return this.nVariablesNoContainers;
        }

        public int noOfNormalVariables() {
            return this.nNormalVariables;
        }

        public int noOfNormalVariablesNoContainer() {
            return this.nNormalVariablesNoContainer;
        }

        public int noOfConstraintVariables() {
            return this.nConstraintVariables;
        }

        public int noOfConstraintVariablesNoContainer() {
            return this.nConstraintVariablesNoContainer;
        }

        public int noOfConstraintInstances() {
            return this.nConstraintInstances;
        }

        public int noOfAnnotations() {
            return this.nAnnotations;
        }
    }
}

