/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import java.util.HashMap;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IVariable;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.CopyVisitor;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.VersionType;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class ExpressionVersionRestriction
implements IVersionRestriction {
    private ConstraintSyntaxTree expr;
    private DecisionVariableDeclaration versionVariable;
    private DecisionVariableDeclaration compoundVersionVariable;

    public ExpressionVersionRestriction(ConstraintSyntaxTree expr, DecisionVariableDeclaration versionVariable, DecisionVariableDeclaration compoundVersionVariable) throws RestrictionEvaluationException {
        this.expr = expr;
        this.versionVariable = versionVariable;
        this.compoundVersionVariable = compoundVersionVariable;
        try {
            IDatatype type = expr.inferDatatype();
            if (!BooleanType.TYPE.isAssignableFrom(type)) {
                throw new RestrictionEvaluationException("restriction expression must be a constraint, i.e., of type Boolean", 10100);
            }
        }
        catch (CSTSemanticException e) {
            throw new RestrictionEvaluationException(e.getMessage(), e.getId(), (Exception)e);
        }
    }

    public static DecisionVariableDeclaration[] createRestrictionVars(String modelName) {
        DecisionVariableDeclaration[] result = new DecisionVariableDeclaration[2];
        Compound cmp = new Compound("$" + modelName, null);
        result[0] = new DecisionVariableDeclaration("version", VersionType.TYPE, cmp);
        cmp.add(result[0]);
        result[1] = new DecisionVariableDeclaration(modelName, cmp, null);
        return result;
    }

    public static ConstraintSyntaxTree createSingleRestriction(DecisionVariableDeclaration var, String operator, Version version) throws ValueDoesNotMatchTypeException, CSTSemanticException {
        ConstraintSyntaxTree result = new Variable(var);
        if (Compound.TYPE.isAssignableFrom(var.getType())) {
            result = new CompoundAccess(result, "version");
        }
        OCLFeatureCall expr = new OCLFeatureCall(result, operator, new ConstantValue(ValueFactory.createValue(VersionType.TYPE, version)));
        ((ConstraintSyntaxTree)expr).inferDatatype();
        return expr;
    }

    public void emit(Object context) {
        if (context instanceof IConstraintTreeVisitor) {
            this.expr.accept((IConstraintTreeVisitor)context);
        }
    }

    public String toSpecification() {
        return StringProvider.toIvmlString(this.expr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean evaluate(IRestrictionEvaluationContext context, Version version) throws RestrictionEvaluationException {
        Boolean result;
        if (context instanceof IConfiguration) {
            Object processor = context.startEvaluation();
            context.setValue((IVariable)this.versionVariable, version);
            context.setValue((IVariable)this.compoundVersionVariable, version);
            EvaluationVisitor visitor = new EvaluationVisitor((IConfiguration)context, null, false, null);
            this.expr.accept(visitor);
            Value value = visitor.getResult();
            visitor.clear();
            context.unsetValue((IVariable)this.versionVariable);
            context.unsetValue((IVariable)this.compoundVersionVariable);
            context.endEvaluation(processor);
            if (value == null) {
                StringBuilder tmp = new StringBuilder();
                int m = 0;
                while (m < visitor.getMessageCount()) {
                    if (m > 0) {
                        tmp.append(", ");
                    }
                    tmp.append(visitor.getMessage(m).getDescription());
                    ++m;
                }
                throw new RestrictionEvaluationException(tmp.toString(), 10108);
            }
            if (!(value instanceof BooleanValue)) throw new RestrictionEvaluationException("restriction cannot be evaluated to Boolean", 10100);
            result = ((BooleanValue)value).getValue();
            return result;
        } else {
            result = false;
        }
        return result;
    }

    public IVersionRestriction copy(IModel model) throws RestrictionEvaluationException {
        DecisionVariableDeclaration[] vars = ExpressionVersionRestriction.createRestrictionVars(model.getName());
        HashMap<AbstractVariable, AbstractVariable> mapping = new HashMap<AbstractVariable, AbstractVariable>();
        mapping.put(this.versionVariable, vars[0]);
        mapping.put(this.compoundVersionVariable, vars[1]);
        CopyVisitor visitor = new CopyVisitor(mapping);
        this.expr.accept(visitor);
        return new ExpressionVersionRestriction(visitor.getResult(), vars[0], vars[1]);
    }

    public IVersionRestriction copy(IVersionRestriction.IVariableMapper mapper) throws RestrictionEvaluationException {
        CopyVisitor visitor = new CopyVisitor(mapper);
        this.expr.accept(visitor);
        return new ExpressionVersionRestriction(visitor.getResult(), this.map(mapper, this.versionVariable), this.map(mapper, this.compoundVersionVariable));
    }

    private DecisionVariableDeclaration map(IVersionRestriction.IVariableMapper mapper, DecisionVariableDeclaration var) {
        DecisionVariableDeclaration result = var;
        IVariable tmp = mapper.map((IVariable)var);
        if (tmp instanceof DecisionVariableDeclaration) {
            result = (DecisionVariableDeclaration)tmp;
        }
        return result;
    }
}

