/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.CustomDatatype;
import net.ssehub.easy.varModel.model.rewrite.UncopiedElement;

class UncopiedElementsContainer {
    private Set<UnresolvedSyntaxContainer> uncopyableCSTs = new HashSet<UnresolvedSyntaxContainer>();
    private Set<AbstractVariable> unresolvedDeclarations = new HashSet<AbstractVariable>();
    private Set<CustomDatatype> unresolvedDatatypes = new HashSet<CustomDatatype>();
    private Set<Attribute> unresolvedAnnotations = new HashSet<Attribute>();
    private Set<ProjectInterface> unresolvedInterfaces = new HashSet<ProjectInterface>();
    private Set<OperationDefinition> incompleteOperations = new HashSet<OperationDefinition>();
    private Set<OperationDefinition> notCopiedOperations = new HashSet<OperationDefinition>();
    private Set<FreezeBlock> uncopiedFreezeBlocks = new HashSet<FreezeBlock>();
    private Set<CompoundAccessStatement> uncopiedCompoundAccesses = new HashSet<CompoundAccessStatement>();
    private Set<UnresolvedAnnotationAssignment> unresolvedAssignments = new HashSet<UnresolvedAnnotationAssignment>();

    UncopiedElementsContainer() {
    }

    void addUnresolvedType(CustomDatatype unresolvedType) {
        this.unresolvedDatatypes.add(unresolvedType);
    }

    Set<CustomDatatype> getUnresolvedTypes() {
        return this.unresolvedDatatypes;
    }

    void addUnresolvedAnnotation(Attribute originalAttribute) {
        this.unresolvedAnnotations.add(originalAttribute);
    }

    void addUnresolvedDeclarationType(AbstractVariable declWithUnresolvedType) {
        this.unresolvedDeclarations.add(declWithUnresolvedType);
    }

    Set<AbstractVariable> getDeclarationsWithMissingTypes() {
        return this.unresolvedDeclarations;
    }

    void addUnresolvedProjectInterface(ProjectInterface orgInterface) {
        this.unresolvedInterfaces.add(orgInterface);
    }

    Set<ProjectInterface> getUnresolvedProjectInterfaces() {
        return this.unresolvedInterfaces;
    }

    void addIncompleteOperation(OperationDefinition incompleteOperation) {
        this.incompleteOperations.add(incompleteOperation);
    }

    Set<OperationDefinition> getIncompleteOperations() {
        return this.incompleteOperations;
    }

    void addUnCopiedOperation(OperationDefinition notCopiedOperation) {
        this.notCopiedOperations.add(notCopiedOperation);
    }

    Set<OperationDefinition> getUncopiedOperations() {
        return this.notCopiedOperations;
    }

    void addFreezeBlock(FreezeBlock notCopiedBlock) {
        this.uncopiedFreezeBlocks.add(notCopiedBlock);
    }

    Set<FreezeBlock> getUncopiedFreezeBlocks() {
        return this.uncopiedFreezeBlocks;
    }

    void addCompoundAccess(CompoundAccessStatement notCopiedCompoundAccess) {
        this.uncopiedCompoundAccesses.add(notCopiedCompoundAccess);
    }

    Set<CompoundAccessStatement> getUncopiedCompoundAccesses() {
        return this.uncopiedCompoundAccesses;
    }

    void addUncopiedAssignment(AttributeAssignment copiedParent, AttributeAssignment.Assignment uncopiedAssignment) {
        UnresolvedAnnotationAssignment outstandingAssignment = new UnresolvedAnnotationAssignment();
        outstandingAssignment.orgAssignment = uncopiedAssignment;
        outstandingAssignment.copiedParentBlock = copiedParent;
        this.unresolvedAssignments.add(outstandingAssignment);
    }

    Set<UnresolvedAnnotationAssignment> getUncopiedAnnotationAssignments() {
        return this.unresolvedAssignments;
    }

    void addUncopyableCST(ContainableModelElement copiedParent, ConstraintSyntaxTree originalCST) {
        UnresolvedSyntaxContainer unresolvedDefault = new UnresolvedSyntaxContainer();
        unresolvedDefault.copiedParent = copiedParent;
        unresolvedDefault.uncopiedCST = originalCST;
        this.uncopyableCSTs.add(unresolvedDefault);
    }

    Set<UnresolvedSyntaxContainer> getUncopyableCSTs() {
        return this.uncopyableCSTs;
    }

    List<UncopiedElement> getUnresolvedElements() {
        ArrayList<UncopiedElement> unrelsovedElements = new ArrayList<UncopiedElement>();
        this.addAll(unrelsovedElements, this.unresolvedDatatypes);
        this.addAll(unrelsovedElements, this.unresolvedDeclarations);
        if (!this.uncopyableCSTs.isEmpty()) {
            for (UnresolvedSyntaxContainer uncopyableCST : this.uncopyableCSTs) {
                unrelsovedElements.add(new UncopiedElement(uncopyableCST));
            }
        }
        this.addAll(unrelsovedElements, this.unresolvedAnnotations);
        this.addAll(unrelsovedElements, this.unresolvedInterfaces);
        this.addAll(unrelsovedElements, this.incompleteOperations);
        this.addAll(unrelsovedElements, this.notCopiedOperations);
        this.addAll(unrelsovedElements, this.uncopiedFreezeBlocks);
        this.addAll(unrelsovedElements, this.uncopiedCompoundAccesses);
        if (!this.unresolvedAssignments.isEmpty()) {
            for (UnresolvedAnnotationAssignment unresolvedAssignment : this.unresolvedAssignments) {
                unrelsovedElements.add(new UncopiedElement(unresolvedAssignment));
            }
        }
        return unrelsovedElements;
    }

    private void addAll(List<UncopiedElement> unrelsovedElements, Collection<? extends ContainableModelElement> elementsToAdd) {
        if (!elementsToAdd.isEmpty()) {
            for (ContainableModelElement containableModelElement : elementsToAdd) {
                unrelsovedElements.add(new UncopiedElement(containableModelElement));
            }
        }
    }

    static class UnresolvedAnnotationAssignment {
        private AttributeAssignment.Assignment orgAssignment;
        private AttributeAssignment copiedParentBlock;

        UnresolvedAnnotationAssignment() {
        }

        AttributeAssignment.Assignment getUnresolvedAssignment() {
            return this.orgAssignment;
        }

        AttributeAssignment getCopiedParent() {
            return this.copiedParentBlock;
        }
    }

    static class UnresolvedSyntaxContainer {
        private ContainableModelElement copiedParent;
        private ConstraintSyntaxTree uncopiedCST;

        UnresolvedSyntaxContainer() {
        }

        ContainableModelElement getCopiedParent() {
            return this.copiedParent;
        }

        ConstraintSyntaxTree getOriginalSyntax() {
            return this.uncopiedCST;
        }

        public String toString() {
            String result = this.copiedParent instanceof AbstractVariable ? this.copiedParent.getName() + " = " : "";
            return result + this.uncopiedCST.toString();
        }
    }
}

