/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.values;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.IValueParent;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public abstract class Value {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(Value.class, "net.ssehub.easy.varModel");
    private IDatatype origin;

    Value() {
    }

    protected Value(IDatatype origin) {
        this.origin = origin;
    }

    public abstract Object getValue();

    public abstract void accept(IValueVisitor var1);

    public abstract void setValue(Object var1) throws ValueDoesNotMatchTypeException;

    public IDatatype getType() {
        return this.origin;
    }

    public abstract boolean isConfigured();

    protected String stringValueOf(Object object) {
        return object == null ? null : object.toString();
    }

    public Value clone() {
        Value clone = null;
        try {
            clone = (Value)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.exception((Exception)e);
        }
        return clone;
    }

    public IDatatype getContainedType() {
        return null;
    }

    public String toString() {
        return String.valueOf(this.getValue()) + " : " + this.getType().toString();
    }

    public abstract boolean equalsPartially(Value var1);

    public static boolean equalsPartially(Value v1, Value v2) {
        boolean equals = v1 == null ? false : v1.equalsPartially(v2);
        return equals;
    }

    public static boolean equals(Value v1, Value v2) {
        boolean equals = v1 == null ? false : v1.equals(v2);
        return equals;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if (this.getClass().isInstance(other)) {
            equal = this.getValue().equals(((Value)other).getValue());
        }
        return equal;
    }

    public void setValueParent(IValueParent parent) {
    }

    public IValueParent getValueParent() {
        return null;
    }
}

