/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cst;

import java.util.Arrays;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.UnknownOperationException;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;

public class ContainerOperationCall
extends ConstraintSyntaxTree {
    private ConstraintSyntaxTree container;
    private String operation;
    private DecisionVariableDeclaration[] declarators;
    private ConstraintSyntaxTree expression;
    private Operation resolvedOperation;
    private IDatatype result;
    private IDatatype iteratorBase;

    ContainerOperationCall() {
    }

    public ContainerOperationCall(ConstraintSyntaxTree container, String operation, ConstraintSyntaxTree expression, DecisionVariableDeclaration ... declarators) {
        assert (container != null);
        this.container = container;
        assert (operation != null);
        this.operation = operation;
        assert (expression != null);
        this.expression = expression;
        assert (declarators != null && declarators.length > 0);
        this.declarators = declarators;
    }

    public String getOperation() {
        return this.operation;
    }

    @Deprecated
    public ConstraintSyntaxTree getSet() {
        return this.container;
    }

    public ConstraintSyntaxTree getContainer() {
        return this.container;
    }

    public ConstraintSyntaxTree getExpression() {
        return this.expression;
    }

    public int getDeclaratorsCount() {
        return this.declarators.length;
    }

    public DecisionVariableDeclaration getDeclarator(int index) {
        return this.declarators[index];
    }

    public IDatatype getContainerType() throws CSTSemanticException {
        IDatatype origContainerType = this.container.inferDatatype();
        IDatatype containerType = DerivedDatatype.resolveToBasis(origContainerType);
        if (!Container.TYPE.isAssignableFrom(containerType)) {
            IDatatype declType;
            IDatatype iteratorType = origContainerType;
            if (Compound.TYPE.isAssignableFrom(iteratorType) && this.declarators != null && this.declarators.length > 0 && (declType = this.declarators[0].getType()) != null && Reference.isReferenceTo(declType, iteratorType)) {
                iteratorType = declType;
            }
            containerType = new Set("", iteratorType, null);
        }
        return containerType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IDatatype inferDatatype() throws CSTSemanticException {
        boolean foundResult;
        IDatatype param;
        if (this.result != null) return this.result;
        if (this.operation == null || this.container == null) throw new CSTSemanticException("<internal error>", 10103);
        IDatatype containerType = this.getContainerType();
        if (!Container.TYPE.isAssignableFrom(containerType)) throw new CSTSemanticException("left hand side is not a container", 10102);
        this.iteratorBase = ((Container)containerType).getContainedType();
        int size = this.declarators.length;
        if (size > 1 && this.declarators[size - 1].getDefaultValue() != null) {
            param = this.declarators[size - 1].getType();
            --size;
            this.expression.inferDatatype();
        } else {
            param = this.expression.inferDatatype();
        }
        boolean bl = foundResult = size != this.declarators.length;
        if ((this.operation.equals("apply") || this.operation.equals("iterate")) && !foundResult) {
            throw new CSTSemanticException("iterate/apply require an initialized return declarator", 10107);
        }
        Operation op = TypeQueries.getOperation(containerType, this.operation, param);
        if (op == null || !op.isContainerOperation()) {
            throw new UnknownOperationException(this.operation, 10101, containerType, param);
        }
        IDatatype iterType = this.declarators[0].getType();
        if (op.getNestingMode() != Operation.NestingMode.NONE && op.getNestingMode() != Operation.NestingMode.LEGACY) {
            while (Container.TYPE.isAssignableFrom(this.iteratorBase) && 1 == this.iteratorBase.getGenericTypeCount()) {
                this.iteratorBase = this.iteratorBase.getGenericType(0);
            }
        }
        if (!iterType.isAssignableFrom(this.iteratorBase)) {
            throw new CSTSemanticException("type '" + IvmlDatatypeVisitor.getUnqualifiedType(iterType) + "' of declarator does not match the contained type of the collection '" + IvmlDatatypeVisitor.getUnqualifiedType(this.iteratorBase) + "'", 10100);
        }
        this.result = op.getActualReturnType(containerType, param);
        this.resolvedOperation = op;
        return this.result;
    }

    @Override
    public void accept(IConstraintTreeVisitor visitor) {
        visitor.visitContainerOperationCall(this);
    }

    public Operation getResolvedOperation() {
        return this.resolvedOperation;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof ContainerOperationCall) {
            ContainerOperationCall other = (ContainerOperationCall)obj;
            equals = this.operation.equals(other.operation);
            equals &= this.container.equals(other.container);
            equals &= Arrays.equals(this.declarators, other.declarators);
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = this.container.hashCode();
        hashCode *= Arrays.hashCode(this.declarators);
        return hashCode *= this.operation.hashCode();
    }

    public IDatatype getIteratorBaseType() {
        return this.iteratorBase;
    }
}

