/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cst;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CSTUtils;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;

public class ValidationVisitor
implements IConstraintTreeVisitor {
    private int assignmentCount;
    private List<String> errors = new ArrayList<String>();

    public ValidationVisitor() {
        this.reset();
    }

    public void clear() {
        this.assignmentCount = 0;
        this.errors.clear();
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public String getError(int index) {
        return this.errors.get(index);
    }

    public String getErrorString() {
        StringBuilder errors = new StringBuilder();
        int e = 0;
        while (e < this.getErrorCount()) {
            if (e > 0) {
                errors.append(", ");
            }
            errors.append(this.getError(e));
            ++e;
        }
        return errors.toString();
    }

    public boolean isAssignment() {
        return this.assignmentCount > 0;
    }

    public boolean isValidAssignment() {
        return 1 == this.assignmentCount;
    }

    public void reset() {
        this.assignmentCount = 0;
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
    }

    @Override
    public void visitVariable(Variable variable) {
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        parenthesis.getExpr().accept(this);
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        int e = 0;
        while (e < initializer.getExpressionCount()) {
            initializer.getExpression(e).accept(this);
            ++e;
        }
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        int e = 0;
        while (e < initializer.getExpressionCount()) {
            initializer.getExpression(e).accept(this);
            ++e;
        }
    }

    @Override
    public void visitComment(Comment comment) {
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        if (call.getOperand() != null) {
            call.getOperand().accept(this);
        }
        int p = 0;
        while (p < call.getParameterCount()) {
            call.getParameter(p).accept(this);
            ++p;
        }
        if (CSTUtils.isAssignment(call)) {
            ++this.assignmentCount;
        }
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        int e = 0;
        while (e < expression.getExpressionCount()) {
            expression.getExpression(e).accept(this);
            ++e;
        }
    }

    @Override
    public void visitLet(Let let) {
        let.getInExpression().accept(this);
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        ifThen.getIfExpr().accept(this);
        ifThen.getElseExpr().accept(this);
        ifThen.getThenExpr().accept(this);
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        call.getContainer().accept(this);
        call.getExpression().accept(this);
        int d = 0;
        while (d < call.getDeclaratorsCount()) {
            if (call.getDeclarator(d).getDefaultValue() != null) {
                call.getDeclarator(d).getDefaultValue().accept(this);
            }
            ++d;
        }
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        access.getCompoundExpression().accept(this);
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
    }

    @Override
    public void visitSelf(Self self) {
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable(variable);
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        int e = 0;
        while (e < block.getExpressionCount()) {
            block.getExpression(e).accept(this);
            ++e;
        }
    }
}

