/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DelegatingType;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.FreezeVariableType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.StringType;

public class TypeMapper {
    public static final Class<?> DELEGATING_CLASS = DelegatingType.class;
    private static final Map<IDatatype, String> TYPE_STRING = new HashMap<IDatatype, String>();
    private static final Map<String, IDatatype> STRING_TYPE = new HashMap<String, IDatatype>();

    static {
        TypeMapper.put("Integer", IntegerType.TYPE);
        TypeMapper.put("Real", RealType.TYPE);
        TypeMapper.put("Boolean", BooleanType.TYPE);
        TypeMapper.put("String", StringType.TYPE);
        TypeMapper.put("Meta", MetaType.TYPE);
        TypeMapper.put("Any", AnyType.TYPE);
        TypeMapper.put("Container", Container.TYPE);
        TypeMapper.put("Set", Set.TYPE);
        TypeMapper.put("Sequence", Sequence.TYPE);
        TypeMapper.put("Compound", Compound.TYPE);
        TypeMapper.put("Derived", DerivedDatatype.TYPE);
        TypeMapper.put("Enum", Enum.TYPE);
        TypeMapper.put("OrderedEnum", OrderedEnum.TYPE);
        TypeMapper.put("Reference", Reference.TYPE);
        TypeMapper.put("Constraint", ConstraintType.TYPE);
        TypeMapper.put("FreezeVariable", FreezeVariableType.TYPE);
    }

    private static final void put(String name, IDatatype type) {
        STRING_TYPE.put(name, type);
        TYPE_STRING.put(type, name);
    }

    public static final String getName(IDatatype type) {
        return TYPE_STRING.get(type);
    }

    public static final IDatatype getType(String name) {
        return STRING_TYPE.get(name);
    }
}

