/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.persistency;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.model.AbstractVisitor;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.IPartialEvaluable;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.Value;

public abstract class AbstractVarModelWriter
extends AbstractVisitor
implements IValueVisitor,
IConstraintTreeVisitor {
    protected static final ModelElement DUMMY_PARENT = new ModelElement("dummy"){

        @Override
        public void accept(IModelVisitor visitor) {
        }
    };
    private static String indentStep = "    ";
    private static boolean useWhitespace = true;
    private static boolean oclCompliance = false;
    private String myIndentStep = indentStep;
    private boolean myUseWhitespace = useWhitespace;
    private int additionalIndentation = 0;
    private List<IModelElement> parents = new ArrayList<IModelElement>();
    private Writer out;
    private IModelElement expressionContext;

    protected AbstractVarModelWriter(Writer writer) {
        this.out = new BufferedWriter(writer);
    }

    protected void setExpressionContext(IModelElement expressionContext) {
        this.expressionContext = expressionContext;
    }

    protected IModelElement getExpressionContext() {
        return this.expressionContext;
    }

    public static void setIndentStep(int count) {
        indentStep = AbstractVarModelWriter.deriveIndentStep(count);
    }

    public void setIndentationStep(int count) {
        if (count != this.myIndentStep.length()) {
            this.myIndentStep = AbstractVarModelWriter.deriveIndentStep(count);
        }
    }

    public static void setOclCompliance(boolean compliance) {
        oclCompliance = compliance;
    }

    public static boolean considerOclCompliance() {
        return oclCompliance;
    }

    public void setUseWhitespaces(boolean useWhitespaces) {
        this.myUseWhitespace = useWhitespaces;
    }

    private static String deriveIndentStep(int count) {
        count = Math.max(0, count);
        StringBuilder tmp = new StringBuilder();
        int i = 0;
        while (i < count) {
            tmp.append(" ");
            ++i;
        }
        return tmp.toString();
    }

    public static String getIvmlIndentStep() {
        return indentStep;
    }

    public static void setUseIvmlWhitespace(boolean use) {
        useWhitespace = use;
    }

    public static boolean getUseIvmlWhitespace() {
        return useWhitespace;
    }

    public void setWriter(Writer writer) {
        this.out = writer;
    }

    public Writer getWriter() {
        return this.out;
    }

    protected final void appendOutput(String appendableOutput) {
        try {
            this.out.write(appendableOutput);
        }
        catch (IOException e) {
            this.getLogger().exception((Exception)e);
        }
    }

    protected final void appendOutput(char appendableOutput) {
        try {
            this.out.write(appendableOutput);
        }
        catch (IOException e) {
            this.getLogger().exception((Exception)e);
        }
    }

    protected final void appendIndentation() {
        try {
            this.out.write(this.getIndentation().toString());
        }
        catch (IOException e) {
            this.getLogger().exception((Exception)e);
        }
    }

    public final void flush() throws IOException {
        this.out.flush();
    }

    protected StringBuffer getIndentation() {
        int depth = this.parents.size();
        StringBuffer indent = new StringBuffer();
        int i = 0;
        while (i < depth + this.additionalIndentation) {
            if (this.myUseWhitespace) {
                indent.append(this.myIndentStep);
            } else {
                indent.append("\t");
            }
            ++i;
        }
        return indent;
    }

    protected IModelElement getParent() {
        IModelElement parent = null;
        if (this.parents.size() > 0) {
            int lastPosition = this.parents.size() - 1;
            while (lastPosition >= 0 && DUMMY_PARENT == this.parents.get(lastPosition)) {
                --lastPosition;
            }
            parent = this.parents.get(lastPosition);
        }
        return parent;
    }

    protected <T extends IModelElement> T getParent(Class<T> type) {
        IModelElement result = null;
        int p = this.parents.size() - 1;
        while (result == null && p >= 0) {
            IModelElement tmp = this.parents.get(p);
            if (type.isInstance(tmp)) {
                result = (IModelElement)type.cast(tmp);
            }
            --p;
        }
        return (T)result;
    }

    protected void removeLastParent() {
        if (this.parents.size() > 0) {
            int lastPosition = this.parents.size() - 1;
            this.parents.remove(lastPosition);
        }
    }

    protected void addParent(IModelElement parent) {
        this.parents.add(parent);
    }

    public abstract boolean emitComments();

    protected abstract void printDefaultSpace(DefaultSpace var1);

    protected abstract void processVersion(Version var1);

    @Override
    public void visitProject(Project project) {
        ContainableModelElement element;
        this.appendIndentation();
        this.startWritingProject(project);
        this.parents.add(project);
        if (project.getVersion() != null) {
            boolean defltSpace = true;
            Comment comment = project.getNestedComment(project.getVersion());
            if (comment != null) {
                defltSpace = false;
                this.appendOutput(comment.getName());
            }
            if (defltSpace) {
                this.printDefaultSpace(DefaultSpace.PROJECT);
            }
            this.processVersion(project.getVersion());
        } else {
            this.printDefaultSpace(DefaultSpace.PROJECT);
        }
        int count = project.getImportsCount();
        int p = 0;
        while (p < count) {
            project.getImport(p).accept(this);
            ++p;
        }
        count = project.getElementCount();
        int c = 0;
        while (c < count) {
            element = project.getElement(c);
            if (element instanceof ProjectInterface) {
                project.getElement(c).accept(this);
            }
            ++c;
        }
        count = project.getAttributesCount();
        int a = project.getAttributesCount();
        while (a < count) {
            project.getAttribute(a).accept(this);
            ++a;
        }
        count = project.getElementCount();
        c = 0;
        while (c < count) {
            element = project.getElement(c);
            if (!(element instanceof ProjectInterface)) {
                project.getElement(c).accept(this);
            }
            ++c;
        }
        this.removeLastParent();
        this.appendIndentation();
        this.endWritingProject(project);
        try {
            this.flush();
        }
        catch (IOException e) {
            this.getLogger().exception((Exception)e);
        }
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
        this.visitEnum(eenum);
    }

    @Override
    public void visitCompound(Compound compound) {
        this.appendIndentation();
        this.startWritingCompound(compound);
        this.parents.add(compound);
        int meCount = compound.getModelElementCount();
        int e = 0;
        while (e < meCount) {
            ContainableModelElement elt = compound.getModelElement(e);
            this.beforeNestedElement(elt);
            elt.accept(this);
            ++e;
        }
        this.removeLastParent();
        this.appendIndentation();
        this.endWritingCompound(compound);
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
        this.parents.add(assignment);
        int m = 0;
        while (m < assignment.getModelElementCount()) {
            assignment.getModelElement(m).accept(this);
            ++m;
        }
        this.removeLastParent();
    }

    protected abstract void startWritingCompound(Compound var1);

    protected abstract void endWritingCompound(Compound var1);

    protected abstract void startWritingProject(Project var1);

    protected abstract void endWritingProject(Project var1);

    @Override
    public void visitConstantValue(ConstantValue value) {
        Value val = value.getConstantValue();
        if (val != null) {
            val.accept(this);
        } else {
            this.appendOutput("<null>");
        }
    }

    @Override
    public void visitConstraintValue(ConstraintValue value) {
        ConstraintSyntaxTree val = value.getValue();
        if (val != null) {
            this.emitConstraintExpression(this.expressionContext, val);
        }
    }

    @Override
    public void visitConstraint(Constraint constraint) {
        ConstraintSyntaxTree cst = constraint.getConsSyntax();
        if (cst != null) {
            this.emitConstraintExpression(constraint, constraint.getConsSyntax());
        }
    }

    protected void emitConstraintExpression(IModelElement context, ConstraintSyntaxTree constraint) {
        this.expressionContext = context;
        constraint.accept(this);
        this.expressionContext = null;
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        this.parents.add(block);
        int e = 0;
        while (e < block.getModelElementCount()) {
            ContainableModelElement cme = block.getModelElement(e);
            if (!(cme instanceof IPartialEvaluable)) {
                block.getModelElement(e).accept(this);
            }
            ++e;
        }
        e = 0;
        while (e < block.getEvaluableCount()) {
            IPartialEvaluable evaluable = block.getEvaluable(e);
            this.beforeNestedElement(evaluable);
            evaluable.accept(this);
            ++e;
        }
        this.removeLastParent();
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
        this.parents.add(freeze);
        int f = 0;
        while (f < freeze.getFreezableCount()) {
            IFreezable freezable = freeze.getFreezable(f);
            this.beforeNestedElement(freezable);
            freezable.accept(this);
            ++f;
        }
        this.removeLastParent();
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        if (expression.isLeaf()) {
            this.appendOutput(expression.getUnresolvedLeaf());
        } else {
            ConstraintSyntaxTree actual = expression.getActualExpression();
            if (actual != null) {
                actual.accept(this);
            }
        }
    }

    protected void beforeNestedElement(Object element) {
    }

    protected int getParentCount() {
        return this.parents.size();
    }

    protected IModelElement getParent(int index) {
        return this.parents.get(index);
    }

    protected void increaseAdditionalIndentation() {
        ++this.additionalIndentation;
    }

    protected void decreaseAdditionalIndentation() {
        if (this.additionalIndentation > 0) {
            --this.additionalIndentation;
        }
    }

    protected EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.varModel");
    }

    protected static enum DefaultSpace {
        PROJECT;

    }
}

