package de.uni_hildesheim.sse.trans;

import java.io.File;

import org.apache.commons.io.FileUtils;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.Suite.SuiteClasses;

import de.uni_hildesheim.sse.trans.convert.DisjunctionCheckerTest;
import de.uni_hildesheim.sse.trans.convert.LiteralFinderTest;
import de.uni_hildesheim.sse.trans.convert.MaxTermConverter2Test;
import de.uni_hildesheim.sse.trans.convert.MaxTermConverterTest;
import de.uni_hildesheim.sse.trans.convert.ModelOptimizerTest;
import de.uni_hildesheim.sse.trans.in.ModelReaderTest;
import de.uni_hildesheim.sse.trans.in.rsf.RSFReaderTest;
import de.uni_hildesheim.sse.trans.out.DimacsWriterTest;


/**
 * Complete test suite.
 * @author El-Sharkawy
 *
 */
@RunWith(Suite.class)
@SuiteClasses({
    ModelReaderTest.class,
    RSFReaderTest.class,
    DisjunctionCheckerTest.class,
    ModelOptimizerTest.class,
    MaxTermConverterTest.class,
    MaxTermConverter2Test.class,
    DimacsWriterTest.class,
    LiteralFinderTest.class
})
public class AllTests {
    
    public static final File TESTDATA = new File("testdata");
    
    public static final File INPUT_FOLDER = new File(TESTDATA, "input");
    public static final File OUTPUT_FOLDER = new File(TESTDATA, "output");
    
    private static boolean cleanUpPerformed = false;

    /**
     * Cleans up the {@link #OUTPUT_FOLDER}.
     */
    @BeforeClass
    public static void setUpBeforeClass() {
        if (!cleanUpPerformed) {
            cleanUpPerformed = true;
            FileUtils.deleteQuietly(OUTPUT_FOLDER);
            OUTPUT_FOLDER.mkdir();
        }
    }
}
