package de.uni_hildesheim.sse.trans.scenario;

import java.io.File;
import java.io.StringWriter;

import org.junit.Assert;
import org.junit.Test;

import de.uni_hildesheim.sse.model.varModel.IvmlKeyWords;
import de.uni_hildesheim.sse.trans.AllTests;
import de.uni_hildesheim.sse.trans.ModelTranslator;
import de.uni_hildesheim.sse.trans.convert.OptimizationParameter;
import de.uni_hildesheim.sse.trans.in.InputType;
import de.uni_hildesheim.sse.trans.out.OutputType;

/**
 * Tests the translation of a RSF file into DIMACS format.
 * @author El-Sharkawy
 *
 */
public class RsfToDimacsTranslationTest {
    
    /**
     * Tests whether Strings are translated correctly.
     */
    @Test
    public void testEmptyStrings() {
        File input = new File(AllTests.INPUT_FOLDER, "testModel_emptyString.rsf");
        StringWriter sWriter = new StringWriter();
        OptimizationParameter noOptimization = new OptimizationParameter();
        String comment = "A comment";
        String version = "0.1";
        
        // Test precondition
        Assert.assertTrue(input.exists());
        Assert.assertFalse(noOptimization.hasAtLeastOneOption());
        
        // Translation
        ModelTranslator.translate(input, sWriter, InputType.RSF, OutputType.DIMCAS, comment, version, noOptimization);
        String result = sWriter.toString();
        System.out.println(result);
        
        // Test correct translation
        //1. comment and version
        Assert.assertNotNull(result);
        Assert.assertTrue(result.startsWith(
            "c " + comment + IvmlKeyWords.LINEFEED + "c Version " + version + IvmlKeyWords.LINEFEED));
    }

}
