/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.check;

import java.util.ArrayList;
import java.util.Collection;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.report.ILanguageNames;
import org.jacoco.report.check.IViolationsOutput;
import org.jacoco.report.check.Limit;
import org.jacoco.report.check.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BundleChecker {
    private final ILanguageNames names;
    private final IViolationsOutput output;
    private final Collection<Rule> bundleRules;
    private final Collection<Rule> packageRules;
    private final Collection<Rule> classRules;
    private final ArrayList<Rule> sourceFileRules;
    private final Collection<Rule> methodRules;
    private final boolean traversePackages;
    private final boolean traverseClasses;
    private final boolean traverseSourceFiles;
    private final boolean traverseMethods;

    public BundleChecker(Collection<Rule> rules, ILanguageNames names, IViolationsOutput output) {
        this.names = names;
        this.output = output;
        this.bundleRules = new ArrayList<Rule>();
        this.packageRules = new ArrayList<Rule>();
        this.classRules = new ArrayList<Rule>();
        this.sourceFileRules = new ArrayList();
        this.methodRules = new ArrayList<Rule>();
        for (Rule rule : rules) {
            switch (rule.getElement()) {
                case BUNDLE: {
                    this.bundleRules.add(rule);
                    break;
                }
                case PACKAGE: {
                    this.packageRules.add(rule);
                    break;
                }
                case CLASS: {
                    this.classRules.add(rule);
                    break;
                }
                case SOURCEFILE: {
                    this.sourceFileRules.add(rule);
                    break;
                }
                case METHOD: {
                    this.methodRules.add(rule);
                }
            }
        }
        this.traverseMethods = !this.methodRules.isEmpty();
        this.traverseClasses = !this.classRules.isEmpty() || this.traverseMethods;
        this.traverseSourceFiles = !this.sourceFileRules.isEmpty();
        this.traversePackages = !this.packageRules.isEmpty() || this.traverseClasses || this.traverseSourceFiles;
    }

    public void checkBundle(IBundleCoverage bundleCoverage) {
        String name = bundleCoverage.getName();
        this.checkRules(bundleCoverage, this.bundleRules, "bundle", name);
        if (this.traversePackages) {
            for (IPackageCoverage p : bundleCoverage.getPackages()) {
                this.check(p);
            }
        }
    }

    private void check(IPackageCoverage packageCoverage) {
        String name = this.names.getPackageName(packageCoverage.getName());
        this.checkRules(packageCoverage, this.packageRules, "package", name);
        if (this.traverseClasses) {
            for (IClassCoverage c : packageCoverage.getClasses()) {
                this.check(c);
            }
        }
        if (this.traverseSourceFiles) {
            for (ISourceFileCoverage s : packageCoverage.getSourceFiles()) {
                this.check(s);
            }
        }
    }

    private void check(IClassCoverage classCoverage) {
        String name = this.names.getQualifiedClassName(classCoverage.getName());
        this.checkRules(classCoverage, this.classRules, "class", name);
        if (this.traverseMethods) {
            for (IMethodCoverage m : classCoverage.getMethods()) {
                this.check(m, classCoverage.getName());
            }
        }
    }

    private void check(ISourceFileCoverage sourceFile) {
        String name = sourceFile.getPackageName() + "/" + sourceFile.getName();
        this.checkRules(sourceFile, this.sourceFileRules, "source file", name);
    }

    private void check(IMethodCoverage method, String className) {
        String name = this.names.getQualifiedMethodName(className, method.getName(), method.getDesc(), method.getSignature());
        this.checkRules(method, this.methodRules, "method", name);
    }

    private void checkRules(ICoverageNode node, Collection<Rule> rules, String typename, String elementname) {
        for (Rule rule : rules) {
            if (!rule.matches(elementname)) continue;
            for (Limit limit : rule.getLimits()) {
                this.checkLimit(node, typename, elementname, rule, limit);
            }
        }
    }

    private void checkLimit(ICoverageNode node, String elementtype, String typename, Rule rule, Limit limit) {
        String message = limit.check(node);
        if (message != null) {
            this.output.onViolation(node, rule, limit, String.format("Rule violated for %s %s: %s", elementtype, typename, message));
        }
    }
}

