package de.uni_hildesheim.sse.trans.in.rsf;

import de.uni_hildesheim.sse.model.cst.ConstraintSyntaxTree;
import de.uni_hildesheim.sse.model.cst.OCLFeatureCall;
import de.uni_hildesheim.sse.model.cst.Variable;
import de.uni_hildesheim.sse.model.varModel.datatypes.Enum;
import de.uni_hildesheim.sse.model.varModel.datatypes.OclKeyWords;
import de.uni_hildesheim.sse.trans.in.AbstractReader;
import de.uni_hildesheim.sse.trans.in.ParserException;

/**
 * A condition to ensure that VAR_MODULE variable is only true, if VAR is true.
 * 
 * @author Adam Krafczyk
 */
class RSFModuleCondition extends RSFCondition {

    private String variable;
    private String moduleVariable;
    
    /**
     * Creates a condition with the given variable and its module version.
     * @param variable The variable
     * @param moduleVariable The module version of the variable
     */
    RSFModuleCondition(String variable, String moduleVariable) {
        this.variable = variable;
        this.moduleVariable = moduleVariable;
    }
    
    @Override
    ConstraintSyntaxTree toPureBooleanConstraintSyntaxTree(RSFReader reader) throws ParserException {
        Variable var = varPool.obtainVariable(reader.getVariable(variable));
        Variable moduleVar = varPool.obtainVariable(reader.getVariable(moduleVariable));
        
        return new OCLFeatureCall(var, OclKeyWords.OR, new OCLFeatureCall(moduleVar, OclKeyWords.NOT));
    }
    
    @Override
    ConstraintSyntaxTree toNotBooleanConstraintSyntaxTree(AbstractReader reader, Enum tristate) throws ParserException {
        // Shouldn't be called since there are not separate _MODULE variables in not boolean models
        return null;
    }

}
