package de.uni_hildesheim.sse.trans.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Will store constraints having the same attribute (like the length of the constraint) into a shared list.
 * @author El-Sharkawy
 *
 * @param <Key> The attribute defining which constraints shall be stored in a shared list,
 *     e.g. length of the constraints.
 * @param <Value> The {@link de.uni_hildesheim.sse.model.varModel.Constraint}s or {@link ConstraintContainer}s.
 */
public class ConstraintMap<Key, Value> {
    private Map<Key, List<Value>> map = new HashMap<Key, List<Value>>();
        
    /**
     * Returns the list of constraints for the given key.
     * Maybe empty, but <b>not</b> <tt>null</tt>.
     * @param key  The attribute defining which constraints shall be stored in a shared list,
     *     e.g. length of the constraints.
     * @return The list of constraints where all constraints having the same <tt>key</tt>.
     */
    public List<Value> getList(Key key) {
        List<Value> constraints = map.get(key);
        if (null == constraints) {
            constraints = new ArrayList<Value>();
            map.put(key, constraints);
        }
        
        return constraints;
    }
    
    /**
     * Returns a {@link Collection} of all {@link de.uni_hildesheim.sse.model.varModel.Constraint} lists.
     * @return {@link Collection} of all {@link de.uni_hildesheim.sse.model.varModel.Constraint} lists.
     */
    public Collection<List<Value>> allLists() {
        return map.values();
    }

}
