package de.uni_hildesheim.sse.trans.convert;

import de.uni_hildesheim.sse.model.cst.Comment;
import de.uni_hildesheim.sse.model.cst.CompoundAccess;
import de.uni_hildesheim.sse.model.cst.CompoundInitializer;
import de.uni_hildesheim.sse.model.cst.ConstantValue;
import de.uni_hildesheim.sse.model.cst.ConstraintSyntaxTree;
import de.uni_hildesheim.sse.model.cst.ContainerInitializer;
import de.uni_hildesheim.sse.model.cst.ContainerOperationCall;
import de.uni_hildesheim.sse.model.cst.IConstraintTreeVisitor;
import de.uni_hildesheim.sse.model.cst.IfThen;
import de.uni_hildesheim.sse.model.cst.Let;
import de.uni_hildesheim.sse.model.cst.OCLFeatureCall;
import de.uni_hildesheim.sse.model.cst.Parenthesis;
import de.uni_hildesheim.sse.model.cst.Self;
import de.uni_hildesheim.sse.model.cst.UnresolvedExpression;
import de.uni_hildesheim.sse.model.cst.Variable;
import de.uni_hildesheim.sse.model.varModel.datatypes.OclKeyWords;

/**
 * Moves negations further into the {@link ConstraintSyntaxTree}.
 * I.e. !(a OR b) will be converted to (!a AND !b).
 * First call accept(), then getResult() to get the result.
 * 
 * @author Adam Krafczyk
 */
class CSTNegater implements IConstraintTreeVisitor {

    private ConstraintSyntaxTree result;
    private boolean negated = false;
    
    /**
     * Getter for the result after an accept() call.
     * @return The modified {@link ConstraintSyntaxTree}.
     */
    public ConstraintSyntaxTree getResult() {
        return result;
    }
    
    @Override
    public void visitConstantValue(ConstantValue value) {
        throw new RuntimeException("Unexpected CST"); // TODO;
    }

    @Override
    public void visitVariable(Variable variable) {
        if (negated) {
            result = new OCLFeatureCall(variable, OclKeyWords.NOT);
        } else {
            result = variable;
        }
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        parenthesis.getExpr().accept(this);
    }

    @Override
    public void visitComment(Comment comment) {
        throw new RuntimeException("Unexpected CST"); // TODO;
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        switch (call.getOperation()) {
        case OclKeyWords.OR:
        case OclKeyWords.AND:
            boolean currentNegated = negated;
            
            result = null;
            call.getOperand().accept(this);
            negated = currentNegated;
            ConstraintSyntaxTree leftSide = getResult();
            
            result = null;
            call.getParameter(0).accept(this);
            negated = currentNegated;
            ConstraintSyntaxTree rightSide = getResult();
            
            String operation = call.getOperation();
            
            if (negated) {
                if (call.getOperation().equals(OclKeyWords.AND)) {
                    operation = OclKeyWords.OR;
                } else {
                    operation = OclKeyWords.AND;
                }
            }
            
            result = new OCLFeatureCall(leftSide, operation, rightSide);
            break;
            
        case OclKeyWords.NOT:
            negated = !negated;
            call.getOperand().accept(this);
            
            // result = result;
            
            break;
        
        default:
            throw new RuntimeException("Unexpected operation"); // TODO;
        }
    }

    @Override
    public void visitLet(Let let) {
        throw new RuntimeException("Unexpected CST"); // TODO;
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        throw new RuntimeException("Unexpected CST"); // TODO;
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        throw new RuntimeException("Unexpected CST"); // TODO;
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        throw new RuntimeException("Unexpected CST"); // TODO;
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        throw new RuntimeException("Unexpected CST"); // TODO;
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        throw new RuntimeException("Unexpected CST"); // TODO;
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        throw new RuntimeException("Unexpected CST"); // TODO;
    }
    
    @Override
    public void visitSelf(Self self) {
        throw new RuntimeException("Unexpected CST"); // TODO;
    }

}
