package de.uni_hildesheim.sse.model_extender;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import de.uni_hildesheim.sse.model_extender.in.DimacsReader;
import de.uni_hildesheim.sse.model_extender.in.MalformedFileException;

/**
 * Main class for running the ModelExtender.
 * 
 * @author Adam Krafczyk
 */
public class Main {

    /**
     * Main-Method to run the ModelExtender.
     * 
     * @param args Command line parameters:
     * <ol>
     *   <li>Path to .dimacs file</li>
     *   <li>Additional constraint</li>
     * </ol>
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Not enough command line arguments");
            System.err.println("Usage: path/to/model.dimacs \"a && b<7\"");
            System.exit(1);
        }
        
        File modelFile = new File(args[0]);
        DimacsReader reader = null;
        try {
            reader = new DimacsReader(modelFile);
        } catch (FileNotFoundException e) {
            System.err.println("File " + modelFile.getPath() + " can't be opened for reading: "
                    + e.getMessage());
            System.exit(1);
        }
        
        //Project model = null;
        try {
            /*model =*/ reader.getModel();
        } catch (IOException | MalformedFileException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
        
        try {
            reader.close();
        } catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

}
