package de.uni_hildesheim.sse.model_extender;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

import de.uni_hildesheim.sse.model.varModel.Project;
import de.uni_hildesheim.sse.model_extender.in.DimacsReader;
import de.uni_hildesheim.sse.model_extender.in.MalformedFileException;
import de.uni_hildesheim.sse.trans.out.DimacsWriter;

/**
 * Main class for running the ModelExtender.
 * 
 * @author Adam Krafczyk
 */
public class Main {

    /**
     * Main-Method to run the ModelExtender.
     * 
     * @param args Command line parameters:
     * <ol>
     *   <li>Path to .dimacs file</li>
     *   <li>Additional constraint</li>
     * </ol>
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Not enough command line arguments");
            System.err.println("Usage: path/to/in/model.dimacs \"a && b<7\" path/to/out/model.dimacs");
            System.exit(1);
        }
        
        File readModelFile = new File(args[0]);
        DimacsReader reader = null;
        try {
            reader = new DimacsReader(readModelFile);
        } catch (FileNotFoundException e) {
            System.err.println("File " + readModelFile.getPath() + " can't be opened for reading: "
                    + e.getMessage());
            System.exit(1);
        }
        
        Project model = null;
        try {
            model = reader.getModel();
        } catch (IOException | MalformedFileException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
        
        try {
            reader.close();
        } catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
        
        // TODO: add constraint to model
        
        File writeModelFile = new File(args[2]);
        try {
            DimacsWriter writer = new DimacsWriter(model, new FileWriter(writeModelFile));
            writer.write();
        } catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

}
