package de.uni_hildesheim.sse.trans.convert;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import de.uni_hildesheim.sse.model.cst.OCLFeatureCall;
import de.uni_hildesheim.sse.model.cst.Variable;
import de.uni_hildesheim.sse.model.varModel.DecisionVariableDeclaration;
import de.uni_hildesheim.sse.model.varModel.datatypes.BooleanType;
import de.uni_hildesheim.sse.model.varModel.datatypes.OclKeyWords;

/**
 * Tests the {@link DeclarationInConstraintFinderWithDepth} class.
 * 
 * @author Adam Krafczyk
 */
public class DeclarationInConstraintFinderWithDepthTest {

    /**
     * Tests if the number of found {@link AbstractVariable}s is correct.
     */
    @Test
    public void test() {
        // Create Constraint with 3 variables
        DecisionVariableDeclaration a = new DecisionVariableDeclaration("a", BooleanType.TYPE, null);
        DecisionVariableDeclaration b = new DecisionVariableDeclaration("b", BooleanType.TYPE, null);
        DecisionVariableDeclaration c = new DecisionVariableDeclaration("c", BooleanType.TYPE, null);
        
        Variable varA = new Variable(a);
        Variable varB = new Variable(b);
        Variable varC = new Variable(c);
        
        OCLFeatureCall call = new OCLFeatureCall(varA, OclKeyWords.AND, varB);
        call = new OCLFeatureCall(call, OclKeyWords.OR, varC);
        
        DeclarationInConstraintFinderWithDepth finder = new DeclarationInConstraintFinderWithDepth(call);
        
        assertEquals(3, finder.getDeclarationsInOrder().size());
        
        assertEquals(c, finder.getDeclarationsInOrder().get(0));
    }

}
