package de.uni_hildesheim.sse.trans.convert;


import org.junit.Assert;
import org.junit.Test;

import de.uni_hildesheim.sse.model.cst.ConstraintSyntaxTree;
import de.uni_hildesheim.sse.model.cst.OCLFeatureCall;
import de.uni_hildesheim.sse.model.cst.Variable;
import de.uni_hildesheim.sse.model.varModel.DecisionVariableDeclaration;
import de.uni_hildesheim.sse.model.varModel.datatypes.BooleanType;
import de.uni_hildesheim.sse.model.varModel.datatypes.OclKeyWords;

/**
 * Tests the {@link CSTExpander} class.
 * 
 * @author Adam Krafczyk
 */
public class CSTExpanderTest {

    /**
     * Tests the {@link CSTExpander}.
     */
    @Test
    public void testCSTSimplifier() {
        DecisionVariableDeclaration declA = new DecisionVariableDeclaration("a", BooleanType.TYPE, null);
        DecisionVariableDeclaration declB = new DecisionVariableDeclaration("b", BooleanType.TYPE, null);
        DecisionVariableDeclaration declC = new DecisionVariableDeclaration("c", BooleanType.TYPE, null);
        
        Variable varA = new Variable(declA);
        Variable varB = new Variable(declB);
        Variable varC = new Variable(declC);
        
        // create: a OR (b AND c)
        OCLFeatureCall call = new OCLFeatureCall(varB, OclKeyWords.AND, varC);
        call = new OCLFeatureCall(varA, OclKeyWords.OR, call);
        
        CSTExpander expander = new CSTExpander(0);
        call.accept(expander);
        
        // result should be: (a OR b) AND (a OR c)
        ConstraintSyntaxTree result = expander.getResult();
        
        Assert.assertTrue(result instanceof OCLFeatureCall);
        
        OCLFeatureCall resultCall = (OCLFeatureCall) result;
        Assert.assertEquals(OclKeyWords.AND, resultCall.getOperation());
        
        Assert.assertTrue(resultCall.getOperand() instanceof OCLFeatureCall);
        Assert.assertTrue(resultCall.getParameter(0) instanceof OCLFeatureCall);
        
        OCLFeatureCall left = (OCLFeatureCall) resultCall.getOperand();
        OCLFeatureCall right = (OCLFeatureCall) resultCall.getParameter(0);
        
        Assert.assertEquals(OclKeyWords.OR, left.getOperation());
        Assert.assertEquals(OclKeyWords.OR, right.getOperation());
        
        Assert.assertTrue(left.getOperand().equals(varA) || left.getParameter(0).equals(varA));
        Assert.assertTrue(left.getOperand().equals(varB) || left.getParameter(0).equals(varB));
        
        Assert.assertTrue(right.getOperand().equals(varA) || right.getParameter(0).equals(varA));
        Assert.assertTrue(right.getOperand().equals(varC) || right.getParameter(0).equals(varC));
    }
    
}
