package de.uni_hildesheim.sse.trans.convert;


import org.junit.Assert;
import org.junit.Test;

import de.uni_hildesheim.sse.model.cst.ConstraintSyntaxTree;
import de.uni_hildesheim.sse.model.cst.OCLFeatureCall;
import de.uni_hildesheim.sse.model.cst.Variable;
import de.uni_hildesheim.sse.model.varModel.DecisionVariableDeclaration;
import de.uni_hildesheim.sse.model.varModel.datatypes.BooleanType;
import de.uni_hildesheim.sse.model.varModel.datatypes.OclKeyWords;

/**
 * Tests the {@link CSTNegater} class.
 * 
 * @author Adam Krafczyk
 */
public class CSTNegaterTest {
    
    /**
     * Tests the {@link CSTNegater}.
     */
    @Test
    public void testCSTNegater() {
        DecisionVariableDeclaration declA = new DecisionVariableDeclaration("a", BooleanType.TYPE, null);
        DecisionVariableDeclaration declB = new DecisionVariableDeclaration("b", BooleanType.TYPE, null);
        DecisionVariableDeclaration declC = new DecisionVariableDeclaration("c", BooleanType.TYPE, null);
        
        Variable varA = new Variable(declA);
        Variable varB = new Variable(declB);
        Variable varC = new Variable(declC);
        
        // create: !(a OR (b AND !c))
        OCLFeatureCall call = new OCLFeatureCall(varC, OclKeyWords.NOT);
        call = new OCLFeatureCall(varB, OclKeyWords.AND, call);
        call = new OCLFeatureCall(varA, OclKeyWords.OR, call);
        call = new OCLFeatureCall(call, OclKeyWords.NOT);
        
        CSTNegater negater = new CSTNegater();
        call.accept(negater);
        
        // result should be: !a AND (!b OR c)
        ConstraintSyntaxTree result = negater.getResult();
        
        Assert.assertTrue(result instanceof OCLFeatureCall);
        
        OCLFeatureCall resultCall = (OCLFeatureCall) result;
        Assert.assertEquals(OclKeyWords.AND, resultCall.getOperation());
        
        Assert.assertTrue(resultCall.getOperand() instanceof OCLFeatureCall);
        Assert.assertEquals(OclKeyWords.NOT,
                ((OCLFeatureCall) resultCall.getOperand()).getOperation());
        Assert.assertEquals(varA,
                ((OCLFeatureCall) resultCall.getOperand()).getOperand());
        
        Assert.assertTrue(resultCall.getParameter(0) instanceof OCLFeatureCall);
        resultCall = (OCLFeatureCall) resultCall.getParameter(0);
        
        Assert.assertEquals(OclKeyWords.OR, resultCall.getOperation());
        Assert.assertEquals(varC, resultCall.getParameter(0));
        
        Assert.assertTrue(resultCall.getOperand() instanceof OCLFeatureCall);
        Assert.assertEquals(OclKeyWords.NOT, ((OCLFeatureCall) resultCall.getOperand()).getOperation());
        Assert.assertEquals(varB, ((OCLFeatureCall) resultCall.getOperand()).getOperand());
    }

}
