package de.uni_hildesheim.sse.model_extender.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import de.uni_hildesheim.sse.trans.convert.MaxTermConverter;
import de.uni_hildesheim.sse.trans.convert.MaxTermConverter2;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;

/**
 * A {@link MaxTermConverter} that instead of adding the constraints to a project
 * just stores them in a {@link List}.
 * 
 * @author Adam Krafczyk
 */
public class ListMaxTermConverter extends MaxTermConverter2 {

    private List<ConstraintSyntaxTree> trees;
    
    /**
     * Creates a new {@link ListMaxTermConverter}.
     */
    public ListMaxTermConverter() {
        trees = new ArrayList<ConstraintSyntaxTree>();
    }
    
    @Override
    protected void addConstraint(ConstraintSyntaxTree cst) {
        trees.add(cst);
    }
    
    /**
     * Getter for the List of created CSTs.
     * 
     * @return An unmodifieable List of CSTs.
     */
    public List<ConstraintSyntaxTree> getCSTs() {
        return Collections.unmodifiableList(trees);
    }
    
}
