package de.uni_hildesheim.sse.trans.convert;

import java.util.HashSet;
import java.util.Set;

import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.datatypes.OclKeyWords;

/**
 * Will find positive and negative declarations in a disjunction term.
 * If a operation is not supported, this visitor will throw a {@link RuntimeException}.
 * @author El-Sharkawy
 *
 */
class LiteralFinder implements IConstraintTreeVisitor {
    
    private static final String NEGATIVE_PREFIX = "not(";
    private static final String NEGATIVE_SUFFIX = ")";
    private boolean isPositive;
    private Set<String> declarations;

    /**
     * Sole constructor for this class, starts the search.
     * @param cst The {@link ConstraintSyntaxTree} where declarations shall be found.
     */
    public LiteralFinder(ConstraintSyntaxTree cst) {
        isPositive = true;
        declarations = new HashSet<String>();
        cst.accept(this);
    }
    
    /**
     * Returns all found declarations inside of the given constraint.
     * @return All declarations, negated declarations will be returned as negated declarations.
     */
    public Set<String> getDeclarations() {
        return declarations;
    }
    
    @Override
    public void visitConstantValue(ConstantValue value) {
        throw new RuntimeException("Not Supported Operation");
    }

    @Override
    public void visitVariable(Variable variable) {
        if (isPositive) {
            declarations.add(variable.getVariable().getName());
        } else {
            declarations.add(NEGATIVE_PREFIX + variable.getVariable().getName() + NEGATIVE_SUFFIX);
        }
    }
    
    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        visitVariable(variable);
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        throw new RuntimeException("Not Supported Operation");
    }

    @Override
    public void visitComment(Comment comment) {
        throw new RuntimeException("Not Supported Operation");
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        if (OclKeyWords.OR.equals(call.getOperation())) {
            call.getOperand().accept(this);
            for (int i = 0, n = call.getParameterCount(); i < n; i++) {
                call.getParameter(i).accept(this);
            }
        } else if (OclKeyWords.NOT.equals(call.getOperation())) {
            isPositive = !isPositive;
            call.getOperand().accept(this);
            for (int i = 0, n = call.getParameterCount(); i < n; i++) {
                call.getParameter(i).accept(this);
            }
            isPositive = !isPositive;
        } else {
            throw new RuntimeException("Not Supported Operation");
        }
    }

    @Override
    public void visitLet(Let let) {
        throw new RuntimeException("Not Supported Operation");
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        throw new RuntimeException("Not Supported Operation");
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        throw new RuntimeException("Not Supported Operation");
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        throw new RuntimeException("Not Supported Operation");
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        throw new RuntimeException("Not Supported Operation");
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        throw new RuntimeException("Not Supported Operation");
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        throw new RuntimeException("Not Supported Operation");
    }

    @Override
    public void visitSelf(Self self) {
        throw new RuntimeException("Not Supported Operation");
    }
}
