package de.uni_hildesheim.sse.trans.in;

import java.io.IOException;

import net.ssehub.easy.varModel.model.Project;

/**
 * General interface for all model readers, which converts files into {@link Project}s.
 * @author El-Sharkawy
 *
 */
public interface IModelReader {
    /**
     * Parses the given file and converts it to a {@link Project}.
     * @return The parsed file as a {@link Project}.
     * @throws IOException If an I/O error occurs
     * @throws ParserException If the input file could not be parsed completely.
     */
    public Project read() throws IOException, ParserException;
}
