package de.uni_hildesheim.sse.trans.convert;

import net.ssehub.easy.varModel.model.Constraint;

/**
 * Strategy for converting a boolean constraint into CNF form.
 * @author El-Sharkawy
 *
 */
public interface ICNFConvertStrategy {

    /**
     * Converts boolean formula into a CNF formula, which may consists of multiple disjunction terms.
     * These constraints should be added to {@link Constraint#getTopLevelParent()}.
     * @param constraint The boolean constraint, which shall be converted.
     */
    public void convert(Constraint constraint);
}
